/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;


public class Core {
	
	private static Logger logger = LoggerFactory.getLogger(Core.class);

    /**
     * Send answer to response stream
     * 
     * @param response
     * @param answer String to put in HTML
     */
    public static void sendOK(HttpServletResponse response, String answer) {
        response.setContentType("text/html");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setStatus(HttpServletResponse.SC_OK);
        try {
            response.getWriter().println(answer);
        } catch (IOException e) {
        	logger.error("Error sending OK message", e);
        }
    }

    /**
     * Send answer to response stream
     * 
     * @param response
     * @param answer String to put in HTML
     */
    public static void sendOK(HttpServletResponse response, String type, byte[] answer) {
        response.setContentType(type);

        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setStatus(HttpServletResponse.SC_OK);
        try {
            OutputStream out = response.getOutputStream();
            out.write(answer);
            out.close();
        } catch (IOException e) {
        	logger.error("Error sending OK message", e);
        }
    }

    public static void sendFail(HttpServletResponse response, String answer) {
        response.setContentType("text/html");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
        try {
            response.getWriter().println(answer);
        } catch (IOException e) {
        	logger.error("Error sending NOT ACCEPTABLE message", e);
        }

    }

    public static JsonObject getJSON(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            reader.close();
        } catch (Exception e) {
            logger.error("Error reading from request", e);
        } 
        JsonParser jsonParser = new JsonParser();
        JsonObject json = (JsonObject) jsonParser.parse(sb.toString());
        return (json);
    }

    /**
     * Checks for error in reply string
     * 
     * @param response
     * @return true if contains error
     */
    public static boolean checkFail(String response) {
        if (response == null) return(true);
        if (response.contains("\"data\":null")) {
        	logger.debug("No error");
        } else logger.debug(response);
        if (response.contains("error")) {
            logger.info(response);
            return (true);
        }
        return (false);
    }
    
    public static boolean checkFail(JsonObject resp) {
    	Gson gson = new Gson();
    	return (checkFail(gson.toJson(resp)));
    }
    
    public static String getError (String response) {
    	try {
    		int i = response.indexOf("{");
    		int j = response.lastIndexOf("}");
    		response = response.substring(i, j+ 1);
    		JsonParser parser = new JsonParser();
    		JsonObject resp = (JsonObject)parser.parse(response);
    		if (resp.has("error_desc")) {
    			return (resp.get("error_desc").getAsString());
    		}
    		else return ("");
    	} catch (Exception ex) {
    		return ("");
    	}
    }

    public static boolean isEncrItem(byte[] data) {
        String head = new String(data, 0, data.length > 100 ? 100 : data.length);
        try {
            Pattern p = Pattern.compile("\\bID: [A-F0-9]{8}(?:-[A-F0-9]{4}){3}-[A-Z0-9]{12}\\b", Pattern.CASE_INSENSITIVE);
            Matcher m = p.matcher(head);
            if (m.find()) {
                return (true);
            }
        } catch (Exception e) {
            logger.error("Error determining whether item is encrypted", e);
        }
        return (false);
    }

    public static String dbformat(String data) {
        if (data == null)
            return (data);
        data = data.replace("'", "\'");
        data = data.replace("`", "\'");
        data = data.replace("\\", "\\\\");
        return (data);
    }
    
    public static String gettime (long start) {
    	return (((System.nanoTime() - start) / 1000000) + "ms");
    }
    
    /**
     * Format response into a JSON object
     * 
     * @param response
     * @return
     * @throws UnsupportedEncodingException
     * @throws IllegalStateException
     * @throws IOException
     */
    public static JsonObject getJson(CloseableHttpResponse response) throws UnsupportedEncodingException, IllegalStateException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
        String json = reader.readLine();
        JsonParser parser = new JsonParser();
        JsonObject result = (JsonObject) parser.parse(json);
        response.close();
        return (result);
    }

}
