/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.setup;

import java.sql.SQLException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;

public class Upgrader {

	private static Logger logger = LoggerFactory.getLogger(Upgrader.class);
	
    final com.openexchange.guard.dbpool.Manager umgr = new com.openexchange.guard.dbpool.Manager();

    /**
     * For future database upgrade action.
     * 
     * @return
     * @throws Exception
     */
    public boolean doUpgrade(int oldversion, int newversion) throws Exception {
        
        if (!com.openexchange.guard.util.CheckOx.oxAlive()) {
            logger.error("OX Not responding.  Will wait 15 seconds and try again");
            Thread.sleep(15000);
            if (!com.openexchange.guard.util.CheckOx.oxAlive()) {
                logger.error("OX Not responding.  Will wait 15 seconds and try again");
                Thread.sleep(15000);
                if (!com.openexchange.guard.util.CheckOx.oxAlive()) {
                    logger.error("FAILED TO CONNECT TO OX BACKEND.  EXITING");
                    System.out.println("Unable to connect to OX backend.  Verify open-xchange-rest is installed and this server has access to port " + Config.ox_backend_port);
                    Runtime.getRuntime().halt(1);
                }
            }
        }
        
        if (oldversion < 6) {
        	try {
        	String command = "SELECT db_pool_id from db_pool WHERE name = 'oxguard'"; 
        	DbCommand com = new DbCommand(command);
        	DbQuery db = new DbQuery();
        	db.readFromConfigDb(com);
        	if (db.next()) {
        		int writeid = db.rs.getInt("db_pool_id");
        		RegisterDb.initDatabase(writeid, "oxguard");
        	}
        	command = "SELECT db_pool_id from db_pool WHERE name = 'oxguard_1'";
        	com = new DbCommand(command);
        	db = new DbQuery();
        	db.readFromConfigDb(com);
        	if (db.next()) {
        		int writeid = db.rs.getInt("db_pool_id");
        		RegisterDb.initDatabase(writeid, "oxguard_1");
        	}
        	db.close();
        	} catch (Exception ex) {

        		logger.error("Error upgrading from " + oldversion + " to " + newversion, ex);
        		return(false);
        	}
        }
        
        try {
            return (setCurrent(newversion));
        } catch (Exception ex) {
            logger.error("Error setting new version to " + newversion, ex);
            return (false);
        }

    }

    private boolean setCurrent(int version) {
        String command = "UPDATE global_settings SET value = ? WHERE global_settings.key = 'version'";
        try {
        	DbCommand com = new DbCommand(command);
        	com.addVariables(version);
        	DbQuery db = new DbQuery();
        	db.writeOxGuard(com);

            return (true);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return (false);
    }

}
