/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.GuardKeys;
import com.openexchange.guard.encr.PGPResult;
import com.openexchange.guard.encr.PGPStringProcessor;


public class PgpHandler {

	private static Logger logger = LoggerFactory.getLogger(PgpHandler.class);
	
    public void getPGPemail(HttpServletRequest request, HttpServletResponse response, com.openexchange.guard.server.OxCookie cookie) {
        try {
            int emailid = Integer.parseInt(request.getParameter("emailid"));
            String folder = request.getParameter("folder");
            int userid = Integer.parseInt(request.getParameter("userid"));
            int cid = Integer.parseInt(request.getParameter("cid"));
            com.openexchange.guard.ox.Api ap = new com.openexchange.guard.ox.Api(cookie, request);
            String mime = ap.getMime(emailid, folder);
            Session s = Session.getDefaultInstance(new Properties());
            InputStream in = new ByteArrayInputStream(mime.getBytes());
            MimeMessage message = new MimeMessage(s, in);
            message.saveChanges();
            System.out.print(message.getSubject());
            Multipart mp = (Multipart) message.getContent();
            Part p = mp.getBodyPart(1);
            PGPStringProcessor pgp = new PGPStringProcessor();
            Access acc = new Access();

            GuardKeys keys = acc.getKeys(userid, cid);

            Address[] fromaddr = message.getFrom();
            String fromemail = fromaddr[0].toString();
            if (fromemail.contains("<")) {
                fromemail = fromemail.substring(fromemail.indexOf("<") + 1, fromemail.indexOf(">"));
            }

            PGPPublicKeyRing sender = acc.getPublicKeyRing(fromemail);
            InputStream inp = p.getInputStream();
            PGPResult result = pgp.DecryptStream(keys.getPGPSecretKeyRing(), EncrLib.getSHA("password", keys.getSalt()), inp, sender);
            if (result.decoded == null) {

            } else {
                response.setContentType("application/json");
                response.setStatus(HttpServletResponse.SC_ACCEPTED);
                response.getWriter().write(createReturnJson(result));
                response.getWriter().flush();
            }
        } catch (Exception ex) {
            logger.error("Error getting PGP email " + request.getParameter("emailid"), ex);
        }

    }

    private String createReturnJson(PGPResult result) throws MessagingException, IOException {
        Session s = Session.getDefaultInstance(new Properties());
        InputStream in2 = new ByteArrayInputStream(result.decoded);
        MimeMessage message2 = new MimeMessage(s, in2);
        System.out.println(message2.getContent());
        Multipart mp = (Multipart) message2.getContent();
        JsonArray attachments = new JsonArray();
        for (int i = 0; i < mp.getCount(); i++) {
            JsonObject attachment = new JsonObject();
            Part p = mp.getBodyPart(i);
            if (p.getContentType() != null) {
                String contentType = p.getContentType();
                if (contentType.contains(";"))
                    contentType = contentType.substring(0, contentType.indexOf(";"));
                attachment.add("content_type", new JsonPrimitive(contentType));
                if (contentType.contains("text/html") || contentType.contains("text/plain")) {
                    if (p.getFileName() == null)
                        attachment.add("disp", new JsonPrimitive("inline"));
                }

            }
            if (p.getFileName() != null)
                attachment.add("filename", new JsonPrimitive(p.getFileName()));
            if (p.getDisposition() != null)
                attachment.add("disp", new JsonPrimitive(p.getDisposition()));
            attachment.add("size", new JsonPrimitive(p.getSize()));
            attachment.add("content", new JsonPrimitive((String) p.getContent()));
            attachment.add("id", new JsonPrimitive(i));
            attachments.add(attachment);
        }
        JsonObject Results = new JsonObject();
        Results.add("signature", new JsonPrimitive(result.signature));
        Results.add("verified", new JsonPrimitive(result.verified));
        if (result.error != null)
            Results.add("error", new JsonPrimitive(result.error));
        JsonObject data = new JsonObject();
        data.add("attachments", attachments);
        data.add("results", Results);

        System.out.println(data.toString());
        return (data.toString());
    }

    public void getKey(HttpServletRequest request, HttpServletResponse response) {
        String email = request.getParameter("email");
        if (email == null) {
            sendFail(response, "Missing Email");
            return;
        }
        ;
        if (!email.contains("@")) {
            sendFail(response, "Bad email format");
            return;
        }
        ;
        com.openexchange.guard.database.Access acc = new com.openexchange.guard.database.Access();
        try {
            GuardKeys keys = acc.getKeysFromEmail(email);
            if (keys != null) {
                sendOK(response, keys.exportPGPPublicKeyRing());
            }
        } catch (Exception ex) {
            logger.error("Error getting key for " + email, ex);
            sendFail(response, "Error processing request");
        }

    }

    private void sendFail(HttpServletResponse response, String answer) {
        response.setContentType("text/html");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
        try {
            response.getWriter().println(answer);
        } catch (IOException e) {
        	logger.error("IO error writing NOT ACCEPTABLE response", e);
        }

    }

    /**
     * Send answer to response stream
     * 
     * @param response
     * @param answer String to put in HTML
     */
    private void sendOK(HttpServletResponse response, String answer) {
        response.setContentType("text/html");
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setStatus(HttpServletResponse.SC_OK);
        try {
            response.getWriter().println(answer);
        } catch (IOException e) {
        	logger.error("IO error writing OK response", e);
        }
    }

}
