/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.server;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.upseller.Upsell;
import com.openexchange.guard.util.CheckOx;
import com.openexchange.guard.util.Core;
import com.openexchange.guard.config.Config;
import com.openexchange.guard.encr.OffsiteKeys;
import com.openexchange.guard.ox.InterOx;

public class MainServlet extends HttpServlet {
	
	private static Logger logger = LoggerFactory.getLogger(MainServlet.class);
	
    private final String actionpattern = "action=[a-z0-9]+";

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long start = System.nanoTime();
        String url = request.getRequestURI();
        logger.debug("url:" + url);
        try {
            if (url.contains("/file/") || url.contains("/mail/")) {// File and attachments may have filename attached for browser data. Remove if present
                int i = url.lastIndexOf("/");
                url = url.substring(0, i);
            }
            url = url.substring(url.lastIndexOf("/"));
        } catch (Exception ex) {
            logger.error("Problem with url " + url);
            return;
        }
        String command = request.getQueryString();
        String action = getAction(command);
        com.openexchange.guard.server.OxCookie cookie = new OxCookie(request.getCookies());

        logger.debug("get action " + action);
        logger.debug("command: " + command);
        switch (url) {
        case "/file":
            FileHandler fh2 = new FileHandler();
            if (action.equals("get")) {
            	fh2.getFile(request, response, cookie, true);
            }
            if (action.equals("remove")) {
                fh2.removeEncryption(request, response, cookie);
            }
            if (action.equals("getshare")) {
                fh2.getShares(request, response, cookie);
            }
            if (action.equals("getfolder")) {
                fh2.getfolder(request, response, cookie);
            }
            break;
        case "/ping":
        	CheckOx.webCheck(response);
        	break;
        case "/mail":
            MailHandler mh = new MailHandler(cookie, request);
            switch (action) {
           
            case ("getattach"):
                mh.getEncrAttach(request, response, cookie);
                break;
            case ("getkey"):
                String email = request.getParameter("email");
                if (email != null) {
                    try {
                        mh.getRecipKey(request, response, email);
                    } catch (Exception e) {
                        response.sendError(500);
                    }
                }
                break;
            case ("count"):
                mh.getReadCount(request, response);
                break;
            case ("retract"):
                mh.retractEmail(request, response, cookie);
                break;
            case ("upsell"):
            	Upsell.getUpsell(request, response);
            	break;
            }

            break;
        case "/pgpmail":
            PgpHandler pg = new PgpHandler();
            switch (action) {
            case ("getmail"):
                pg.getPGPemail(request, response, cookie);
                break;

            case ("getkey"):
                pg.getKey(request, response);
                break;
            }
            break;
        case "/guest":
            Guest gst = new Guest();
            switch (action) {
            case ("getattach"):
                try {
                    gst.getEncrAttach(request, response, cookie);
                } catch (Exception e) {
                    response.sendError(500);
                }
                break;
            case ("getquestion"):
                gst.getQuestion(request, response, cookie);
                break;
            case ("resetpassword"):
                gst.resetPassword(request, response, cookie);
                break;
            }
            break;
        case "/interox":
            InterOx iox = new InterOx();
            switch (action) {
            case ("getkey"):
                iox.getKey(request, response);
                break;
            case ("getcount"):
                iox.getReadCount(request, response);
                break;
            case ("retract"):
                iox.retract(request, response);
                break;
            case ("verify"):
                iox.verifyToken(request, response);
                break;
            case ("remshare"):
                iox.deleteshare(request, response);
            }
            break;
        case "/keys":
            OffsiteKeys ok = new OffsiteKeys();
            switch (action) {
            case ("getckey"):
                ok.getCCKey(request, response, cookie);
                break;

            }
            break;
        case "/login":
            Auth auth = new Auth();
            switch (action) {

            case ("logout"):
                try {
                    auth.logout(request, response, cookie);
                } catch (Exception e) {
                	logger.error("Error logging in", e);
                    response.sendError(500);
                }
                break;
	        case ("reset"): 
	        	try {
	        		auth.resetPass(request, response, cookie);
	        	} catch (Exception e) {
	        		logger.error("Error resetting", e);
	                response.sendError(500);
	            }
            	break;
	        case ("secondary"):
	        	try {
	        		auth.getSecondaryEmail(request, response, cookie);
	        	} catch (Exception e) {
	        		logger.error("Error getting secondary e-mail", e);
	                response.sendError(500);
	        	}
            }
            break;
        case "/demo":
            if (!Config.demo) {
            	logger.error("Attempted demo reset, but not configured for demo.  Add demo:true to config file is needed");
                break; // This is only to be used in demo servers!!!!
            }
            switch (action) {
            case ("reset"):
                try {
                    DemoClass demo = new DemoClass();
                    demo.Reset(request, response);
                } catch (Exception e) {
                    response.sendError(500);
                }
                break;
            }
            break;
        default:
            response.sendError(404);
            break;
        }
        logger.debug("GET processed, time " + Core.gettime(start));
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {

        String url = request.getRequestURI();

        com.openexchange.guard.server.OxCookie cookie = new OxCookie(request.getCookies());
        String command = request.getQueryString();
        String action = getAction(command);
        try {
            url = url.substring(url.lastIndexOf("/"));
        } catch (Exception ex) {
            logger.error("Problem with url " + url);
            return;
        }
        logger.debug("url:" + url);
        logger.debug("delete action: " + action);
        logger.debug("command: " + command);
        switch (url) {
        case "/file":
            FileHandler fh = new FileHandler();
            switch (action) {
            case "remshare":
                fh.removeShare(request, response, cookie);
                break;
            }
            break;
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException {

        String url = request.getRequestURI();

        com.openexchange.guard.server.OxCookie cookie = new OxCookie(request.getCookies());
        String command = request.getQueryString();
        String action = getAction(command);
        try {
            url = url.substring(url.lastIndexOf("/"));
        } catch (Exception ex) {
            logger.error("Problem with url " + url);
            return;
        }
        logger.debug("url:" + url);
        logger.debug("put action: " + action);
        logger.debug("command: " + command);
        switch (url) {
        case "/mail":
            MailHandler mh = new MailHandler(cookie, request);
            switch (action) {
            case ("saveattachment"):
                mh.saveDecodedAttach(request, response, cookie);
                System.out.println("save attach called");
                break;
            }
            break;
        case "/file":
            FileHandler fh = new FileHandler();
            switch (action) {
            case ("share"):
                fh.share(request, response, cookie);
                break;
            case ("folderperm"):
                fh.addFolderShare(request, response, cookie);
                break;
            }
            break;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {

        long start = System.nanoTime();
        String url = request.getRequestURI();

        com.openexchange.guard.server.OxCookie cookie = new OxCookie(request.getCookies());
        String command = request.getQueryString();
        String action = getAction(command);
        try {
            url = url.substring(url.lastIndexOf("/"));
        } catch (Exception ex) {
            logger.error("Problem with url " + url);
            return;
        }
        logger.debug("url:" + url);
        logger.debug("post action: " + action);
        logger.debug("command: " + command);
        switch (url) {
        case "/mail":
            // Call mail(action);
            logger.debug("Handle mail");
            MailHandler mh = new MailHandler(cookie, request);
            switch (action) {
            case ("emailform"):
                mh.incomingEmailForm(request, response);
                break;
            case ("getmail"):
                try {
                    mh.getEncrEmail(request, response, cookie);
                } catch (Exception e) {
                    response.sendError(500);
                }
                break;
            }
            break;
            
        case "/file":
            FileHandler fh = new FileHandler();
            switch (action) {
            case ("encrypt"):
                fh.encryptFile(request, response, cookie);
                break;
        	case ("addextra"): 
                fh.addExtraPassword(request, response, cookie);
            break;
            }

        case "/files":// coming from OX UI Uploader
            FileHandler fh3 = new FileHandler();
            switch (action) {
            case ("new"):
                fh3.downloadFormFromClient(request, response, cookie, false);
                break;
            case ("update"):
                fh3.downloadFormFromClient(request, response, cookie, true);
                break;
            }
            break;
        case "/mailattach":
            FileHandler fh2 = new FileHandler();
            fh2.downloadFormFromClient(request, response, cookie, false);
            break;
        case "/guest":
            Guest guest = new Guest();
            switch (action) {
            case ("changepass"):
                guest.ChangePass(request, response, cookie);
                break;
            case ("getmail"):
                guest.GetEmail(request, response, cookie);
                break;
        	}
            break;
        case "/login":
            Auth auth = new Auth();
            switch (action) {

            case ("login"):
                auth.login(request, response, cookie);
                break;
            case ("guest"):
                auth.guestlogin(request, response);
                break;
            case ("changepass"):
                try {
                    auth.changepass(request, response, cookie);
                } catch (Exception e) {
                	logger.error("Error changing password", e);
                    response.sendError(500);
                }
                break;
            case ("oxpassreset"):
                try {
                    auth.changepassFromOxRecovery(request, response, cookie);
                } catch (Exception e) {
                	logger.error("Error during password reset", e);
                    response.sendError(500);
                    e.printStackTrace();
                }
                break;
            case ("create"):
                try {
                    auth.createKeys(request, response, cookie);
                } catch (Exception e1) {
                    response.sendError(500);
                    logger.error("Error creating keys", e1);
                }

                break;
            case ("changesecondary"):
            	try {
            		auth.changeSecondaryEmail(request, response, cookie);
            	} catch (Exception e) {
                    response.sendError(500);
                    logger.error("Error changing secondary email", e);
                }
            	break;
            }
            break;
        case "/interox":
            InterOx iox = new InterOx();
            switch (action) {
            case ("saveitem"):
                iox.saveItem(request, response);
                break;
            }
            break;
        case "/keys":
            OffsiteKeys ok = new OffsiteKeys();
            switch (action) {
            case ("changepublic"):
                ok.changePublic(request, response, cookie);
                break;
            }
            break;
        default:
            response.sendError(404);
            break;
        }
        logger.debug("POST action processed, time " + Core.gettime(start));
    }

    /**
     * Parse action from command string
     * 
     * @param command
     * @return
     */
    private String getAction(String command) {
        String action = "";
        try {
            command = command.toLowerCase();
            if (command.contains("action=")) {
                action = command.substring(command.indexOf("action="));
                if (action.contains("&")) {
                    action = action.substring(0, action.indexOf("&"));
                }
                action = action.substring(7);
            }
        } catch (Exception ex) {

        }
        return (action);
    }
    
}
