/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
/**
 * For lockout of bad IP / itemID / Sessions
 * 
 */

package com.openexchange.guard.server;

import java.sql.Timestamp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;


public class CheckBad {
	
	private static Logger logger = LoggerFactory.getLogger(CheckBad.class);

    /**
     * Check if id is listed as bad.
     * 
     * @param id Could be IP, itemID, or session
     * @param threshold Number of bad tries within time period acceptable
     * @return
     */
    public static boolean isBad(String id, int threshold) {
        boolean bad = false;
        try {
            String command = "SELECT *, NOW() as cur FROM Bad WHERE Bad.id = ?";
            DbCommand com = new DbCommand(command);
            com.addVariables(id);
            DbQuery db = new DbQuery();
            db.readOG(com);

            if (db.next()) {
                Timestamp last = db.rs.getTimestamp("last");
                Timestamp cur = db.rs.getTimestamp("cur");
                long differential = Config.bad_minute_lock * 60 * 1000;
                if (last.getTime() > (cur.getTime() - differential)) {
                    if (db.rs.getInt("count") > threshold) {
                        bad = true;
                    }
                }
            }
            db.close();
        } catch (Exception ex) {
            logger.error("Error while checking whether ID " + id + " was bad", ex);
        }
        return (bad);
    }

    /**
     * Add the id to bad count
     * 
     * @param id
     */
    public static void addBad(String id) {
        try {
            if (id == null)
                return;
            String command = "DELETE FROM Bad WHERE last < DATE_SUB(NOW(), INTERVAL " + Config.bad_minute_lock + " MINUTE);";
            DbCommand com = new DbCommand(command);
            DbQuery db = new DbQuery();
            db.writeOxGuard(com);
            command = "INSERT INTO Bad VALUES (?, 1, NOW()) ON DUPLICATE KEY UPDATE count = count + 1, last = NOW()";
            com = new DbCommand(command);
            com.addVariables(id);
            db.writeOxGuard(com);
            db.close();
        } catch (Exception ex) {
            logger.error("Error while adding ID " + id + " to the bad count", ex);
        }
    }
    
    public static void removeBad(String id) {
        try {
            if (id == null)
                return;
            String command = "DELETE FROM Bad WHERE id = ?";
            DbCommand com = new DbCommand(command);
            com.addVariables(id);
            DbQuery db = new DbQuery();
            db.writeOxGuard(com);
            db.close();
        } catch (Exception ex) {
            logger.error("Error while removing ID " + id + " from the bad count", ex);
        }
    }
}
