/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.encr;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gson.JsonObject;
import com.openexchange.guard.database.Access;
import com.openexchange.guard.database.DbCommand;
import com.openexchange.guard.database.DbQuery;
import com.openexchange.guard.database.RetrievedItem;
import com.openexchange.guard.server.Auth;

public class OffsiteKeys {

	private static Logger logger = LoggerFactory.getLogger(OffsiteKeys.class);
    /**
     * Change the encryption of all content keys to new public key.
     * 
     * @param priv Old private key
     * @param newpub New public key
     * @param userid
     * @param cid
     * @return
     * @throws Exception
     */
    public boolean changeKeys(PrivateKey priv, PublicKey newpub, int userid, int cid) throws Exception {
        ArrayList<Item> items = new ArrayList<Item>();
        String email = "";
        boolean success = true;
        EncrLib encr = new EncrLib();
        String command = "SELECT * from og_content_keys WHERE CID = ? AND UserId = ?";
        DbCommand com = new DbCommand(command);
        com.addVariables(cid);
        com.addVariables(userid);
        DbQuery db = new DbQuery();
        db.read(com, userid, cid);
        try {
            while (db.next() && success) {
                Item item = new Item();
                item.ItemID = db.rs.getString("ItemId");
                String encrContentKey = db.rs.getString("ContentKey");
                item.ContentKey = encr.decryptRSA(encrContentKey, priv);
                if (item.ContentKey == null)
                    success = false;
                items.add(item);
            }
        } catch (Exception ex) {
            logger.error("Error while changing keys", ex);
            success = false;

        }
        db.close();
        if (success) {
            for (int i = 0; i < items.size(); i++) {
                Item item = items.get(i);
                String newKey = encr.encryptRSA(item.ContentKey, newpub);
                com = new DbCommand("UPDATE og_content_keys SET ContentKey = ? WHERE ItemID = ? AND UserID = ? AND CID = ?");
                com.addVariables(newKey);
                com.addVariables(item.ItemID);
                com.addVariables(userid);
                com.addVariables(cid);
                db.write(com, userid, cid);
            }
        }
        db.close();
        return (success);
    }

    /**
     * Change the public key, keeping the private offsite
     * 
     * @param request
     * @param response
     * @param cookie
     */
    public void changePublic(HttpServletRequest request, HttpServletResponse response, com.openexchange.guard.server.OxCookie cookie) {
        String returndata = "{\"reponse\" : \"Fail\"}";
        try {
            Auth auth = new Auth();
            JsonObject json = auth.getJSON(request);
            com.openexchange.guard.ox.Api api = new com.openexchange.guard.ox.Api(cookie, request);
            if (!api.verifyLogin()) {
                response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
                response.getWriter().write("Must be logged into OX UI");
                return;
            }

            String password = json.get("password").getAsString();
            String newpub = json.get("publicKey").getAsString();
            int id = json.get("userid").getAsInt();
            int cid = json.get("cid").getAsInt();
            Access acc = new Access();
            GuardKeys keys = acc.getKeys(id, cid);
            keys.setPublicKeyFrom64String(getKeyfromPem(newpub));

            if (keys.getPublic() != null) {
                if (changeKeys(keys.getDecodedPrivate(password), keys.getPublic(), id, cid)) {
                    updateKeys(id, cid, keys);
                    returndata = "{\"reponse\" : \"OK\"}";
                }
            }
        } catch (Exception ex) {
            logger.error("Error while changing public key", ex);
            logger.debug(returndata);
            try {
                response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
                response.getWriter().write(returndata);
            } catch (IOException e) {
                logger.error("Error while writing response", e);
            }
        }

    }

    private String getKeyfromPem(String data) {
        if (data.contains("-----BEGIN PUBLIC KEY-----")) {
            data = data.replace("-----BEGIN PUBLIC KEY-----", "");
            data = data.replace("-----END PUBLIC KEY-----", "");
            data = data.trim();
        }
        return (data);
    }

    private void updateKeys(int id, int cid, GuardKeys key) throws Exception {
        String command = "UPDATE og_KeyTable SET RSAPrivate = NULL, Recovery = ' ', RSAPublic = ?, lastMod = NOW() WHERE id = ? AND cid = ?";
        try {
            DbCommand com = new DbCommand(command);
            com.addVariables(key.getEncodedPublic());
            com.addVariables(id);
            com.addVariables(cid);
            DbQuery db = new DbQuery();
            db.write(com, id, cid);
            db.close();
        } catch (SQLException e) {
            logger.error("SQL error while updating keys", e);
        }

    }

    public void getCCKey(HttpServletRequest request, HttpServletResponse response, com.openexchange.guard.server.OxCookie cookie) {
            com.openexchange.guard.ox.Api api = new com.openexchange.guard.ox.Api(cookie, request);
            try {
	            if (!api.verifyLogin()) {
	                response.getWriter().write("Must be logged into OX UI");
	                return;
	            }
	            Access acc = new Access();
	            String ItemId = request.getParameter("itemid");
	            int user = Integer.parseInt(request.getParameter("userid"));
	            int cid = Integer.parseInt(request.getParameter("cid"));
	            RetrievedItem item = acc.getItemID(ItemId, user, cid);
				response.getWriter().write(item.contentKey);
			} catch (IOException e) {
				logger.error("Could not write response");
			} catch (Exception e) {
				logger.error("Error while getting CC key");
			}
            return;
    }
}
