/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DisableAlarmActionsRequestMarshaller
implements Marshaller<Request<DisableAlarmActionsRequest>, DisableAlarmActionsRequest> {
    @Override
    public Request<DisableAlarmActionsRequest> marshall(DisableAlarmActionsRequest disableAlarmActionsRequest) {
        if (disableAlarmActionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisableAlarmActionsRequest> request = new DefaultRequest<DisableAlarmActionsRequest>(disableAlarmActionsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DisableAlarmActions");
        request.addParameter("Version", "2010-08-01");
        List<String> alarmNamesList = disableAlarmActionsRequest.getAlarmNames();
        int alarmNamesListIndex = 1;
        for (String alarmNamesListValue : alarmNamesList) {
            if (alarmNamesListValue != null) {
                request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringUtils.fromString(alarmNamesListValue));
            }
            ++alarmNamesListIndex;
        }
        return request;
    }
}

