/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Comparator;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.IOUtils;

public class PlainTextDictionary
implements Dictionary {
    private BufferedReader in;

    public PlainTextDictionary(File file) throws FileNotFoundException {
        this.in = new BufferedReader(new FileReader(file));
    }

    public PlainTextDictionary(InputStream dictFile) {
        this.in = new BufferedReader(new InputStreamReader(dictFile));
    }

    public PlainTextDictionary(Reader reader) {
        this.in = new BufferedReader(reader);
    }

    public BytesRefIterator getWordsIterator() throws IOException {
        return new FileIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class FileIterator
    implements BytesRefIterator {
        private boolean done = false;
        private final BytesRef spare = new BytesRef();

        FileIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public BytesRef next() throws IOException {
            if (this.done) {
                return null;
            }
            boolean success = false;
            try {
                String line = PlainTextDictionary.this.in.readLine();
                if (line != null) {
                    this.spare.copyChars((CharSequence)line);
                    return this.spare;
                }
                this.done = true;
                IOUtils.close((Closeable[])new Closeable[]{PlainTextDictionary.this.in});
                return null;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{PlainTextDictionary.this.in});
                throw throwable;
            }
        }

        public Comparator<BytesRef> getComparator() {
            return null;
        }
    }
}

