/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import com.facebook.api.ApplicationProperty;
import com.facebook.api.BatchQuery;
import com.facebook.api.ErrorCode;
import com.facebook.api.ExtensibleClient;
import com.facebook.api.FacebookException;
import com.facebook.api.FacebookMethod;
import com.facebook.api.IFacebookMethod;
import com.facebook.api.MarketListingCategory;
import com.facebook.api.MarketListingSubcategory;
import com.facebook.api.Pair;
import com.facebook.api.schema.FacebookApiException;
import com.facebook.api.schema.FriendsGetResponse;
import com.facebook.api.schema.Listing;
import com.facebook.api.schema.MarketplaceGetListingsResponse;
import com.facebook.api.schema.MarketplaceGetSubCategoriesResponse;
import com.facebook.api.schema.MarketplaceSearchResponse;
import com.facebook.api.schema.SessionInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONArray;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookJaxbRestClient
extends ExtensibleClient<Object> {
    private static final Map<FacebookMethod, String> RETURN_TYPES = new HashMap<FacebookMethod, String>();

    public FacebookJaxbRestClient(String apiKey, String secret) {
        super(apiKey, secret);
    }

    public FacebookJaxbRestClient(String apiKey, String secret, int connectionTimeout) {
        super(apiKey, secret, connectionTimeout);
    }

    public FacebookJaxbRestClient(String apiKey, String secret, String sessionKey) {
        super(apiKey, secret, sessionKey);
    }

    public FacebookJaxbRestClient(String apiKey, String secret, String sessionKey, int connectionTimeout) {
        super(apiKey, secret, sessionKey, connectionTimeout);
    }

    public FacebookJaxbRestClient(String serverAddr, String apiKey, String secret, String sessionKey) throws MalformedURLException {
        super(serverAddr, apiKey, secret, sessionKey);
    }

    public FacebookJaxbRestClient(String serverAddr, String apiKey, String secret, String sessionKey, int connectionTimeout) throws MalformedURLException {
        super(serverAddr, apiKey, secret, sessionKey, connectionTimeout);
    }

    @Override
    public FriendsGetResponse friends_get() throws IOException, FacebookException {
        return (FriendsGetResponse)super.friends_get();
    }

    public FacebookJaxbRestClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        super(serverUrl, apiKey, secret, sessionKey);
    }

    public FacebookJaxbRestClient(URL serverUrl, String apiKey, String secret, String sessionKey, int connectionTimeout) {
        super(serverUrl, apiKey, secret, sessionKey, connectionTimeout, -1);
    }

    public FacebookJaxbRestClient(URL serverUrl, String apiKey, String secret, String sessionKey, int connectionTimeout, int readTimeout) {
        super(serverUrl, apiKey, secret, sessionKey, connectionTimeout, readTimeout);
    }

    @Override
    public String getResponseFormat() {
        return "xml";
    }

    private String parse() {
        String xml = this.rawResponse;
        if (xml == null || "".equals(xml)) {
            return null;
        }
        if (!xml.contains("</")) {
            return null;
        }
        xml = xml.substring(0, xml.indexOf("</"));
        xml = xml.substring(xml.lastIndexOf(">") + 1);
        return xml;
    }

    @Override
    public String extractString(Object val) {
        return this.parse();
    }

    @Override
    public String auth_getSession(String authToken) throws FacebookException, IOException {
        if (null != this._sessionKey) {
            return this._sessionKey;
        }
        JAXBElement obj = (JAXBElement)this.callMethod((IFacebookMethod)FacebookMethod.AUTH_GET_SESSION, new Pair<String, String>("auth_token", authToken.toString()));
        SessionInfo d = (SessionInfo)obj.getValue();
        this._sessionKey = d.getSessionKey();
        this._userId = d.getUid();
        this._expires = d.getExpires();
        if (this._isDesktop) {
            this._sessionSecret = d.getSecret();
        }
        return this._sessionKey;
    }

    @Override
    protected Object parseCallResult(InputStream data, IFacebookMethod method) throws FacebookException, IOException {
        Object res;
        if (this.isDebug()) {
            System.out.println("Facebook response:  " + this.rawResponse);
        }
        if ((res = this.getResponsePOJO()) instanceof FacebookApiException) {
            FacebookApiException error = (FacebookApiException)res;
            int errorCode = error.getErrorCode();
            String message = error.getErrorMsg();
            throw new FacebookException(errorCode, message);
        }
        return res;
    }

    @Override
    protected URL extractURL(Object url) throws IOException {
        String result = this.parse();
        if (result != null) {
            return new URL(result);
        }
        return null;
    }

    @Override
    protected int extractInt(Object val) {
        try {
            return Integer.parseInt(this.parse());
        }
        catch (Exception cce) {
            return 0;
        }
    }

    @Override
    protected boolean extractBoolean(Object val) {
        String result = this.parse();
        return "1".equals(result) || "true".equalsIgnoreCase(result);
    }

    @Override
    protected Long extractLong(Object val) {
        try {
            return Long.parseLong(this.parse());
        }
        catch (Exception cce) {
            return 0L;
        }
    }

    @Override
    public String data_getUserPreference(Integer prefId) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public Map<Integer, String> data_getUserPreferences() throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public void data_setUserPreference(Integer prefId, String value) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public void data_setUserPreferences(Map<Integer, String> values, boolean replace) throws FacebookException, IOException {
        throw new FacebookException(ErrorCode.GEN_UNKNOWN_METHOD, "The FacebookJsonRestClient does not support this API call.  Please use an instance of FacebookRestClient instead.");
    }

    @Override
    public List<Listing> marketplace_getListings(List<Long> listingIds, List<Long> uids) throws FacebookException, IOException {
        MarketplaceGetListingsResponse resp = (MarketplaceGetListingsResponse)((Object)this.marketplace_getListings(listingIds, uids));
        return resp.getListing();
    }

    @Override
    public List<String> marketplace_getSubCategories() throws FacebookException, IOException {
        MarketplaceGetSubCategoriesResponse resp = (MarketplaceGetSubCategoriesResponse)this.marketplace_getSubCategories(null);
        return resp.getMarketplaceSubcategory();
    }

    @Override
    public List<Listing> marketplace_search(MarketListingCategory category, MarketListingSubcategory subcategory, String searchTerm) throws FacebookException, IOException {
        MarketplaceSearchResponse resp = (MarketplaceSearchResponse)this.marketplace_search(category.getName(), subcategory.getName(), (CharSequence)searchTerm);
        return resp.getListing();
    }

    @Override
    public String admin_getAppPropertiesAsString(Collection<ApplicationProperty> properties) throws FacebookException, IOException {
        if (this._isDesktop) {
            throw new FacebookException(ErrorCode.GEN_PERMISSIONS_ERROR, "Desktop applications cannot use 'admin.getAppProperties'");
        }
        JSONArray props = new JSONArray();
        for (ApplicationProperty property : properties) {
            props.put((Object)property.getName());
        }
        this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_APP_PROPERTIES, new Pair<String, String>("properties", props.toString()));
        return this.extractString((Object)null);
    }

    @Override
    public List<? extends Object> executeBatch(boolean serial) throws FacebookException, IOException {
        this.batchMode = false;
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<BatchQuery> buffer = new ArrayList<BatchQuery>();
        while (!this.queries.isEmpty()) {
            buffer.add((BatchQuery)this.queries.remove(0));
            if (buffer.size() != 15 && !this.queries.isEmpty()) continue;
            this.batch_run(this.encodeMethods(buffer), serial);
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(new ByteArrayInputStream(this.rawResponse.getBytes("UTF-8")));
                NodeList responses = doc.getElementsByTagName("batch_run_response_elt");
                for (int count = 0; count < responses.getLength(); ++count) {
                    String response = FacebookJaxbRestClient.extractNodeString(responses.item(count));
                    try {
                        this.rawResponse = response;
                        Object pojo = this.parseCallResult(null, null);
                        String type = RETURN_TYPES.get(((BatchQuery)buffer.get(count)).getMethod());
                        if (type.equals("default")) {
                            result.add(pojo);
                            continue;
                        }
                        if (type.equals("string")) {
                            result.add(this.extractString(pojo));
                            continue;
                        }
                        if (type.equals("bool")) {
                            result.add(this.extractBoolean(pojo));
                            continue;
                        }
                        if (type.equals("int")) {
                            result.add(this.extractInt(pojo));
                            continue;
                        }
                        if (type.equals("long")) {
                            result.add(this.extractLong(pojo));
                            continue;
                        }
                        result.add(null);
                        continue;
                    }
                    catch (Exception e) {
                        if (result.size() >= count + 1) continue;
                        result.add(null);
                    }
                }
            }
            catch (Exception ignored) {
            }
        }
        return result;
    }

    public static String extractNodeString(Node d) {
        if (d == null) {
            return null;
        }
        return d.getFirstChild().getTextContent();
    }

    static {
        Method[] candidates = FacebookJaxbRestClient.class.getMethods();
        block0: for (FacebookMethod method : EnumSet.allOf(FacebookMethod.class)) {
            String name = method.methodName();
            name = name.substring(name.indexOf(".") + 1);
            name = name.replace(".", "_");
            for (Method candidate : candidates) {
                if (!candidate.getName().equalsIgnoreCase(name)) continue;
                String typeName = candidate.getReturnType().getName().toLowerCase();
                if (typeName.indexOf("object") != -1) {
                    RETURN_TYPES.put(method, "default");
                    continue block0;
                }
                if (typeName.indexOf("string") != -1) {
                    RETURN_TYPES.put(method, "string");
                    continue block0;
                }
                if (typeName.indexOf("bool") != -1) {
                    RETURN_TYPES.put(method, "bool");
                    continue block0;
                }
                if (typeName.indexOf("long") != -1) {
                    RETURN_TYPES.put(method, "long");
                    continue block0;
                }
                if (typeName.indexOf("int") != -1) {
                    RETURN_TYPES.put(method, "int");
                    continue block0;
                }
                if (typeName.indexOf("applicationpropertyset") != -1 || typeName.indexOf("list") != -1 || typeName.indexOf("url") != -1 || typeName.indexOf("map") != -1 || typeName.indexOf("object") != -1) {
                    RETURN_TYPES.put(method, "default");
                    continue block0;
                }
                RETURN_TYPES.put(method, "void");
                continue block0;
            }
        }
    }
}

