/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.authn.oauth;

import com.google.gdata.client.authn.oauth.OAuthException;
import com.google.gdata.client.authn.oauth.OAuthHmacSha1Signer;
import com.google.gdata.client.authn.oauth.OAuthHttpClient;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthSigner;
import com.google.gdata.client.authn.oauth.OAuthUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OAuthHelper {
    private String requestTokenUrl;
    private String userAuthorizationUrl;
    private String accessTokenUrl;
    private OAuthHttpClient httpClient;
    private OAuthSigner signer;

    public OAuthHelper(String requestTokenUrl, String userAuthorizationUrl, String accessTokenUrl, OAuthSigner signer) {
        this(requestTokenUrl, userAuthorizationUrl, accessTokenUrl, signer, new OAuthHttpClient());
    }

    OAuthHelper(String requestTokenUrl, String userAuthorizationUrl, String accessTokenUrl, OAuthSigner signer, OAuthHttpClient httpClient) {
        this.requestTokenUrl = requestTokenUrl;
        this.userAuthorizationUrl = userAuthorizationUrl;
        this.accessTokenUrl = accessTokenUrl;
        this.signer = signer;
        this.httpClient = httpClient;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String url) {
        this.accessTokenUrl = url;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    public void setRequestTokenUrl(String url) {
        this.requestTokenUrl = url;
    }

    public String getUserAuthorizationUrl() {
        return this.userAuthorizationUrl;
    }

    public void setUserAuthorizationUrl(String url) {
        this.userAuthorizationUrl = url;
    }

    public void getUnauthorizedRequestToken(OAuthParameters oauthParameters) throws OAuthException {
        oauthParameters.assertOAuthConsumerKeyExists();
        if (this.signer instanceof OAuthHmacSha1Signer) {
            oauthParameters.assertOAuthConsumerSecretExists();
        }
        boolean oauthCallbackExists = false;
        if (oauthParameters.checkOAuthCallbackExists()) {
            String callback = oauthParameters.getOAuthCallback();
            oauthParameters.addCustomBaseParameter("oauth_callback", callback);
            oauthCallbackExists = true;
        }
        URL url = this.getOAuthUrl(this.requestTokenUrl, "GET", oauthParameters);
        String response = this.httpClient.getResponse(url);
        Map<String, String> queryString = OAuthUtil.parseQuerystring(response);
        oauthParameters.setOAuthToken(queryString.get("oauth_token"));
        oauthParameters.setOAuthTokenSecret(queryString.get("oauth_token_secret"));
        if (oauthCallbackExists) {
            oauthParameters.removeCustomBaseParameter("oauth_callback");
        }
        oauthParameters.reset();
    }

    @Deprecated
    public String getUserAuthorizationUrl(OAuthParameters oauthParameters) throws OAuthException {
        this.getUnauthorizedRequestToken(oauthParameters);
        return this.createUserAuthorizationUrl(oauthParameters);
    }

    public String createUserAuthorizationUrl(OAuthParameters oauthParameters) {
        QueryKeyValuePair queryParams = new QueryKeyValuePair();
        queryParams.add("oauth_token", oauthParameters.getOAuthToken());
        if (oauthParameters.getOAuthCallback().length() > 0) {
            queryParams.add("oauth_callback", oauthParameters.getOAuthCallback());
        }
        return this.userAuthorizationUrl + "?" + queryParams.toString();
    }

    public void getOAuthParametersFromCallback(URL url, OAuthParameters oauthParameters) {
        this.getOAuthParametersFromCallback(url.getQuery(), oauthParameters);
    }

    public void getOAuthParametersFromCallback(String queryString, OAuthParameters oauthParameters) {
        Map<String, String> params = OAuthUtil.parseQuerystring(queryString);
        oauthParameters.setOAuthToken(params.get("oauth_token"));
        if (params.get("oauth_token_secret") != null) {
            oauthParameters.setOAuthTokenSecret(params.get("oauth_token_secret"));
        }
        if (params.get("oauth_verifier") != null) {
            oauthParameters.setOAuthVerifier(params.get("oauth_verifier"));
        }
    }

    public String getAccessToken(URL url, OAuthParameters oauthParameters) throws OAuthException {
        return this.getAccessToken(url.getQuery(), oauthParameters);
    }

    public String getAccessToken(String queryString, OAuthParameters oauthParameters) throws OAuthException {
        this.getOAuthParametersFromCallback(queryString, oauthParameters);
        return this.getAccessToken(oauthParameters);
    }

    public String getAccessToken(OAuthParameters oauthParameters) throws OAuthException {
        oauthParameters.assertOAuthConsumerKeyExists();
        oauthParameters.assertOAuthTokenExists();
        if (this.signer instanceof OAuthHmacSha1Signer) {
            oauthParameters.assertOAuthConsumerSecretExists();
            oauthParameters.assertOAuthTokenSecretExists();
        }
        URL url = this.getOAuthUrl(this.accessTokenUrl, "GET", oauthParameters);
        String response = this.httpClient.getResponse(url);
        Map<String, String> queryString = OAuthUtil.parseQuerystring(response);
        oauthParameters.setOAuthToken(queryString.get("oauth_token"));
        oauthParameters.setOAuthTokenSecret(queryString.get("oauth_token_secret"));
        oauthParameters.reset();
        return oauthParameters.getOAuthToken();
    }

    public String getAuthorizationHeader(String requestUrl, String httpMethod, OAuthParameters oauthParameters) throws OAuthException {
        oauthParameters.assertOAuthConsumerKeyExists();
        if (this.signer instanceof OAuthHmacSha1Signer) {
            oauthParameters.assertOAuthConsumerSecretExists();
        }
        this.addCommonRequestParameters(requestUrl, httpMethod, oauthParameters);
        HeaderKeyValuePair headerParams = new HeaderKeyValuePair();
        headerParams.add("realm", oauthParameters.getRealm());
        headerParams.add("oauth_signature", oauthParameters.getOAuthSignature());
        for (Map.Entry<String, String> e : oauthParameters.getBaseParameters().entrySet()) {
            if (e.getValue().length() <= 0) continue;
            headerParams.add(e.getKey(), e.getValue());
        }
        oauthParameters.reset();
        return "OAuth" + " " + headerParams.toString();
    }

    private URL getOAuthUrl(String baseUrl, String httpMethod, OAuthParameters oauthParameters) throws OAuthException {
        this.addCommonRequestParameters(baseUrl, httpMethod, oauthParameters);
        QueryKeyValuePair queryParams = new QueryKeyValuePair();
        for (Map.Entry<String, String> e : oauthParameters.getBaseParameters().entrySet()) {
            if (e.getValue().length() <= 0) continue;
            queryParams.add(e.getKey(), e.getValue());
        }
        queryParams.add("oauth_signature", oauthParameters.getOAuthSignature());
        StringBuilder fullUrl = new StringBuilder(baseUrl);
        fullUrl.append(baseUrl.indexOf("?") > 0 ? "&" : "?");
        fullUrl.append(queryParams.toString());
        try {
            return new URL(fullUrl.toString());
        }
        catch (MalformedURLException mue) {
            throw new OAuthException(mue);
        }
    }

    private void addCommonRequestParameters(String baseUrl, String httpMethod, OAuthParameters oauthParameters) throws OAuthException {
        if (oauthParameters.getOAuthSignatureMethod().length() == 0) {
            oauthParameters.setOAuthSignatureMethod(this.signer.getSignatureMethod());
        }
        if (oauthParameters.getOAuthTimestamp().length() == 0) {
            oauthParameters.setOAuthTimestamp(OAuthUtil.getTimestamp());
        }
        if (oauthParameters.getOAuthNonce().length() == 0) {
            oauthParameters.setOAuthNonce(OAuthUtil.getNonce());
        }
        if (oauthParameters.getOAuthSignature().length() == 0) {
            String baseString = OAuthUtil.getSignatureBaseString(baseUrl, httpMethod, oauthParameters.getBaseParameters());
            oauthParameters.setOAuthSignature(this.signer.getSignature(baseString, oauthParameters));
        }
    }

    private static class HeaderKeyValuePair
    extends KeyValuePair {
        public HeaderKeyValuePair() {
            super("=\"", "\"", ", ");
        }
    }

    private static class QueryKeyValuePair
    extends KeyValuePair {
        public QueryKeyValuePair() {
            super("=", "", "&");
        }
    }

    private static abstract class KeyValuePair {
        private List<String> keys;
        private List<String> values;
        private String keyValueStartDelimiter;
        private String keyValueEndDelimiter;
        private String pairDelimiter;

        protected KeyValuePair(String keyValueStartDelimiter, String keyValueEndDelimiter, String pairDelimiter) {
            this.keyValueStartDelimiter = keyValueStartDelimiter;
            this.keyValueEndDelimiter = keyValueEndDelimiter;
            this.pairDelimiter = pairDelimiter;
            this.keys = new ArrayList<String>();
            this.values = new ArrayList<String>();
        }

        public void add(String key, String value) {
            this.keys.add(key);
            this.values.add(value);
        }

        public String getKey(int i) {
            return this.keys.get(i);
        }

        public String getValue(int i) {
            return this.values.get(i);
        }

        public int size() {
            return this.keys.size();
        }

        public String toString() {
            StringBuilder keyValueString = new StringBuilder();
            int length = this.size();
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    keyValueString.append(this.pairDelimiter);
                }
                keyValueString.append(OAuthUtil.encode(this.getKey(i))).append(this.keyValueStartDelimiter).append(OAuthUtil.encode(this.getValue(i))).append(this.keyValueEndDelimiter);
            }
            return keyValueString.toString();
        }
    }
}

