/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples.json;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.json.DataObjectFactory;

public final class SaveRawJSON {
    public static void main(String[] args) {
        Twitter twitter = new TwitterFactory().getInstance();
        System.out.println("Saving public timeline.");
        try {
            new File("statuses").mkdir();
            ResponseList statuses = twitter.getPublicTimeline();
            Iterator i$ = statuses.iterator();
            while (i$.hasNext()) {
                Status status = (Status)i$.next();
                String rawJSON = DataObjectFactory.getRawJSON((Object)status);
                String fileName = "statuses/" + status.getId() + ".json";
                SaveRawJSON.storeJSON(rawJSON, fileName);
                System.out.println(fileName + " - " + status.getText());
            }
            System.out.print("\ndone.");
            System.exit(0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println("Failed to store tweets: " + ioe.getMessage());
        }
        catch (TwitterException te) {
            te.printStackTrace();
            System.out.println("Failed to get timeline: " + te.getMessage());
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeJSON(String rawJSON, String fileName) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(fileName);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osw);
            bw.write(rawJSON);
            bw.flush();
        }
        finally {
            if (null != bw) {
                try {
                    bw.close();
                }
                catch (IOException ignore) {}
            }
            if (null != osw) {
                try {
                    osw.close();
                }
                catch (IOException ignore) {}
            }
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

