/*
 * Decompiled with CFR 0.152.
 */
package de.kippdata.solrext.tokenfilter;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class DomainSkipFilter
extends TokenFilter {
    private List<String> domains;
    private final CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private static final Log log = LogFactory.getLog(DomainSkipFilter.class);

    public DomainSkipFilter(TokenStream input, List<String> domains) {
        super(input);
        this.domains = domains;
        log.debug((Object)"[DomainSkipFilter]: Instantiated.");
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            for (String s : this.domains) {
                if (!this.termAttr.toString().endsWith(s)) continue;
                this.termAttr.setLength(this.termAttr.length() - s.length());
                return true;
            }
            return true;
        }
        return false;
    }
}

