/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.Origins;
import com.amazonaws.services.cloudfront.model.transform.OriginStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OriginsStaxUnmarshaller
implements Unmarshaller<Origins, StaxUnmarshallerContext> {
    private static OriginsStaxUnmarshaller instance;

    @Override
    public Origins unmarshall(StaxUnmarshallerContext context) throws Exception {
        Origins origins = new Origins();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return origins;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    origins.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Items/Origin", targetDepth)) continue;
                origins.getItems().add(OriginStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return origins;
    }

    public static OriginsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginsStaxUnmarshaller();
        }
        return instance;
    }
}

