/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2013 Open-Xchange Inc., Tarrytown, NY, USA. info@open-xchange.com
 *
 * @author Julian Bäume <julian.baeume@open-xchange.com>
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 */

(function () {

    'use strict';

    //
    // Plugin functions
    //

    function onInsertEmoji(e) {
        e.preventDefault();

        var recently = {},
            icon = $(e.target).data('icon'),
            html = '<img src="apps/themes/login/1x1.gif" rel="0" ' +
                'class="emoji ' + icon.css + '" data-emoji-unicode="' + icon.unicode + '" ' +
                'data-mce-resize="false">';

        this.emoji.recent(icon.unicode);
        this.editor.execCommand('mceInsertContent', false, html);
    }

    // this is called for each editor instance
    function init(ed, url) {
        var view = null;

        ed.addCommand('mceInsertEmoji', function (ui) {

            if (view === null) {
                // load required code now
                require(['io.ox/core/emoji/view'], function (EmojiView) {
                    // create instance only once per editor
                    view = new EmojiView({ editor: ed, onInsertEmoji: onInsertEmoji });
                    // hook into tinyMCE's DOM
                    var container = $(ed.getContainer());
                    if (container.find('.mce-edit-area').length > 0) {
                        //work-around for Bug 34943 - can be removed for 7.8.0
                        container.find('.mce-edit-area').prepend(
                            view.$el
                        );
                        console.log(container, container.find('.mce-edit-area').length);
                    } else {
                        //work-around for Bug 34943 - only the next line is needed for 7.8.0 (new mail compose)
                        $(String('#' + ed.id + '.editable')).parent().find('.editable-toolbar').append(view.$el);
                    }
                    view.toggle();
                });
            } else {
                view.toggle();
            }
        });

        // TODO: translate title
        ed.addButton('emoji', {
            tooltip: 'Insert Emoji',
            icon: 'emoticons',
            onclick: function (e) {
                ed.execCommand('mceInsertEmoji', true, { event: e, editor: ed });
            }
        });
    }

    window.tinymce.PluginManager.add('emoji', init);

}());
