/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Andreas Mayer <andreas.mayer@open-xchange.com>
 * 
 */
 
 /**
 * Inplace editing functionality.
 * @param {Object} div The DOM node which will be replaced by input tag
 * @param {String} text The initial text for the input tag
 * @param {Function} fn_save A function which saves new text and call the update
 * function. 
 */
function inplaceEdit(div, text, fn_save) {
	this.container_edit = div;
	this.old_content = [];
	this.input_elem = null;
	this.old_text = text;
	this.really_edit_check = true;
	this.style = { fontSize: "9pt", color: "black", height: "1.3em", margin: "0", padding: "0", 
			width:"100%", borderWidth: "0px", background: "transparent" };
	this.fn_save = fn_save;
	this.mode = "off";
}

inplaceEdit.prototype = {
	
	setSelection: function(bool) {
		this.container_edit.style.MozUserSelect = bool ? "text" : null;
	},

	on: function() {
		var Self = this;
		if (this.mode=="on") {
			return;
		}
		triggerEvent("OX_Clear_All_Edit_Lines");
		
		function save_checkTarget(event) {		
			if (Self.mode!="on" || event.target == Self.input_elem || 
				event.srcElement == Self.input_elem) {
				return true;
			}
			save();
		}
		
		function save(event) {
		    var close = true;
			if (Self.input_elem.value != Self.old_text || !Self.really_edit_check) {
				close = Self.fn_save(Self.input_elem.value);
			}
			if (close !== false) {
			    clear_input(event);
			}
		}
		
		function stop_click_bubbl(evtt) {
			cancelBubbling(evtt);
		}
		
		//catch esc. event on body
		function on_key_body(event) {
			if (event && event.keyCode == 27) {
				clear_input(event);
			}
			return event;
		}
			
		//replace contect of the container div with old content
		function clear_input(e) {
			Self.mode = "off";
			Self.setSelection(false);
			if (typeof(Self.input_elem) != "object") {
				return;
			}
			removeDOMEvent(Self.input_elem,"blur",save);
			removeDOMEvent(body,"click",save_checkTarget);
			removeDOMEvent(body,'keydown',on_key_body);
			removeDOMEvent(Self.input_elem,'keydown',on_key);
			removeDOMEvent(Self.input_elem,'keypress',on_key);
			removeDOMEvent(Self.container_edit,"click",stop_click_bubbl);
			removeDOMEvent(Self.container_edit,"mousedown",stop_click_bubbl);
			if (Self.input_elem.parentNode.parentNode == Self.container_edit) {
				Self.container_edit.removeChild(Self.input_elem.parentNode);
			}
			for (var nIndx in Self.old_content) {
				Self.container_edit.appendChild(Self.old_content[nIndx]);
			}
			unregister("OX_Clear_All_Edit_Lines",clear_input);	
			cancelfunc=true;		
			draggingdisable = false;
			triggerEvent("OX_Dummy", e);
		}
		
		//store old content
		for(var nIndx in this.container_edit.childNodes) {
			if(typeof(this.container_edit.childNodes[nIndx]) == "object") {
				this.old_content[nIndx] = this.container_edit.childNodes[nIndx].cloneNode(true);
			}
		}
		
		//replace old content
		removeChildNodes(this.container_edit);
		this.setSelection(true);
		
		//create input element		
		this.input_elem = newnode('input', this.style, { type:'text', value: this.old_text });
		var oDiVtest = newnode("div", 
			   { overflow: "hidden", position: "relative", width:"100%" }, null,
			   [ this.input_elem ]);
		this.container_edit.appendChild(oDiVtest);	
		addDOMEvent(oDiVtest, "selectstart", function() { menuselectstart=true; });
		addDOMEvent(oDiVtest, "mousedown", function() { menumousedown=true; });

		if (Self.input_elem && Self.mode != "on") {
			Self.input_elem.focus();
			Self.mode = "on";
			draggingdisable = true;
			cancelfunc=false;
			Self.input_elem.value = Self.old_text;
			Self.input_elem.select();
		}
	
		function on_key(event) {
			if (event.keyCode == 13) {
				if (Self.input_elem.value != Self.old_text || !Self.really_edit_check) {
					Self.input_elem.blur();
				}
			} else if (event.keyCode == 27) {
				clear_input(event);
			}
			cancelBubbling(event);
			return event;
		}

		addDOMEvent(this.input_elem,'keydown',on_key);
		addDOMEvent(this.input_elem,'keypress',on_key);
		addDOMEvent(this.input_elem,"blur",save);
		addDOMEvent(this.container_edit,"click", stop_click_bubbl);
		addDOMEvent(this.container_edit,"mousedown", stop_click_bubbl);
		addDOMEvent(body,"click",save_checkTarget);
		addDOMEvent(body,'keydown',on_key_body);
		register("OX_Clear_All_Edit_Lines",clear_input);
	}
};
fileloaded();