package com.openexchange.office.tools.logging.impl;

import java.io.IOException;

import javax.servlet.ServletOutputStream;

//=============================================================================
class BufferedServletOutputStream extends ServletOutputStream
{
	//-------------------------------------------------------------------------
    public BufferedServletOutputStream(final StringBuffer        aBufferedOut,
    		                           final ServletOutputStream aRealOut    )
    {
    	m_aBufferedOut = aBufferedOut;
    	m_aRealOut     = aRealOut;
    }

	//-------------------------------------------------------------------------
	@Override
	public void write(final int aByte)
		throws IOException
	{
		m_aBufferedOut.append((char)aByte);
		m_aRealOut.write     (      aByte);
	}

	//-------------------------------------------------------------------------
    private StringBuffer m_aBufferedOut = null;
    
	//-------------------------------------------------------------------------
    private ServletOutputStream m_aRealOut = null;
}