package com.openexchange.office.tools.logging.impl;

import java.io.ByteArrayInputStream;

import javax.servlet.ServletInputStream;

//=============================================================================
class BufferedServletInputStream extends ServletInputStream
{
	//-------------------------------------------------------------------------
    public BufferedServletInputStream(final String sBuffer)
    {
    	m_sBuffer = sBuffer;
    }

	//-------------------------------------------------------------------------
    public int available()
    {
    	return mem_BufferedStream ().available();
    }

	//-------------------------------------------------------------------------
    public int read()
    {
    	return mem_BufferedStream ().read();
    }

	//-------------------------------------------------------------------------
    public int read(final byte[] aBuffer,
    				final int    nOffset,
    				final int    nLength)
    {
    	return mem_BufferedStream ().read(aBuffer, nOffset, nLength);
    }

	//-------------------------------------------------------------------------
    private ByteArrayInputStream mem_BufferedStream ()
    {
    	if (m_aBufferedStream == null)
    		m_aBufferedStream = new ByteArrayInputStream (m_sBuffer.getBytes());
    	return m_aBufferedStream;
    }
    
	//-------------------------------------------------------------------------
    private String m_sBuffer = null;

	//-------------------------------------------------------------------------
    private ByteArrayInputStream m_aBufferedStream = null;
}