/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.realtime.osgi;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.apache.commons.logging.Log;

import com.openexchange.capabilities.CapabilityService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.conversion.simple.SimplePayloadConverter;
import com.openexchange.documentconverter.IManager;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.filemanagement.DistributedFileManagement;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.jslob.JSlobService;
import com.openexchange.office.IResourceProvider;
import com.openexchange.office.calcengine.client.CalcEngineClientFactory;
import com.openexchange.office.realtime.impl.ConnectionComponent;
import com.openexchange.office.realtime.impl.JSON2MessageData;
import com.openexchange.office.realtime.impl.MessageData2JSON;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.realtime.Component;
import com.openexchange.realtime.cleanup.GlobalRealtimeCleanup;
import com.openexchange.realtime.cleanup.RealtimeJanitor;
import com.openexchange.timer.TimerService;
import com.openexchange.user.UserService;

//The activator does the service wiring, as usual.
public class ConnectionActivator extends HousekeepingActivator {

    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] {
            com.openexchange.office.odf.Importer.class,
            com.openexchange.office.odf.Exporter.class,
            com.openexchange.office.ooxml.pptx.Importer.class,
            com.openexchange.office.ooxml.pptx.Exporter.class,
            com.openexchange.office.ooxml.docx.Importer.class,
            com.openexchange.office.ooxml.docx.Exporter.class,
            com.openexchange.office.ooxml.xlsx.Importer.class,
            com.openexchange.office.ooxml.xlsx.Exporter.class,
            IResourceProvider.class,
            ConfigurationService.class,
            CapabilityService.class,
            IDBasedFileAccessFactory.class,
            FolderService.class,
            ManagedFileManagement.class,
            DistributedFileManagement.class,
            CalcEngineClientFactory.class,
            UserService.class,
            TimerService.class,
            com.openexchange.sessiond.SessiondService.class,
            GlobalRealtimeCleanup.class,
            JSlobService.class
        };
    }

    /* (non-Javadoc)
     * @see com.openexchange.osgi.HousekeepingActivator#getOptionalServices()
     */
    @Override
    protected Class<?>[] getOptionalServices() {
        return new Class<?>[] {
            IManager.class
        };
    }

    /* (non-Javadoc)
     * @see com.openexchange.osgi.DeferredActivator#startBundle()
     */
    @Override
    protected void startBundle() throws Exception {
        final Log log = com.openexchange.log.Log.loggerFor(ConnectionActivator.class);

        Services.setServiceLookup(this);

        if (log.isInfoEnabled()) {
            log.info("starting bundle: " + m_serviceName);
        }

        registerService(Component.class, component = new ConnectionComponent(this));
        // Register the Component as RealtimeJanitor that can be tracked via OSGI and used when a cleanup is needed
        registerService(RealtimeJanitor.class, component);
        registerService(SimplePayloadConverter.class, new MessageData2JSON());
        registerService(SimplePayloadConverter.class, new JSON2MessageData());

        // You have to provide these converters if you want to put non JSON classes into
        // Payload trees.

        // Also, if you want to receive non-json data, which is usually very convenient, you
        // can declare that a payload with a certain namespace and element name should always be
        // Converted into a specific format. For that see the PayloadTreeConverter interface

        openTrackers();
    }

    @Override
    protected void stopBundle() throws Exception {
        final Log log = com.openexchange.log.Log.loggerFor(ConnectionActivator.class);

        if (log.isInfoEnabled()) {
            log.info("stopping bundle: " + m_serviceName);
        }

        if (null != component) {
            component.shutdown();
        }

        Services.setServiceLookup(null);

        cleanUp();
    }

    @Override
    /**
     * Called by the HousekeepingActivator when a needed service will be
     * unavailable after handleUnavailability() returns.
     *
     * @see com.openexchange.osgi.HousekeepingActivator#handleUnavailability()
     */
    protected void handleUnavailability(final Class<?> clazz) {
        final Log log = com.openexchange.log.Log.loggerFor(ConnectionActivator.class);

        lock.lock();
        try {
	        if (!shutdownProcessed) {
	            if (log.isInfoEnabled()) {
	                log.info("bundle: " + m_serviceName + " detected that a required service was removed.");
	            }

	            shutdownProcessed = true;
                stopBundle();
	        }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        } finally {
            lock.unlock();
        }
    }

    // - Members ---------------------------------------------------------------
    
    private final String m_serviceName = "com.openexchange.office.realtime";

    private boolean shutdownProcessed = false;

    private final Lock lock = new ReentrantLock();

    private ConnectionComponent component = null;
}
