/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.realtime.impl;

import org.json.JSONObject;
import com.openexchange.realtime.packet.ID;


/**
 * {@link OperationsMessage}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class MessageData {

    // - Constants -------------------------------------------------------------

    static final String KEY_CLIENT_ID = "clientId";
    static final String KEY_UNIQUE_ID = "uniqueId";
    static final String KEY_ERROR_CODE = "errorCode";
    static final String KEY_FILE_NAME = "fileName";
    static final String KEY_FILE_VERSION = "fileVersion";
    static final String KEY_FILE_CHANGERESULT = "fileChangeResult";
    static final String KEY_TARGET_FOLDER = "targetFolder";
    static final String KEY_DOC_COPYRESULT = "docCopyResult";
    static final String KEY_FILE_ID = "fileId";
    static final String KEY_FOLDER_ID = "folderId";
    static final String KEY_AS_TEMPLATE = "asTemplate";

    static final int SAVE_ERROR_NONE = 0;
    static final int SAVE_ERROR_NOBACKUP = 100;
    static final int SAVE_ERROR_OPERATIONS = 101;
    static final int SAVE_ERROR_FILE_NOT_FOUND = 102;
    static final int SAVE_ERROR_QUOTA_REACHED = 103;

    /**
     * Initializes a new {@link MessageData}.
     * @param operationsChunk
     * @param queueStatus
     */
    public MessageData(MessageChunk operationsChunk, ConnectionStatus queueStatus) {
        super();

        this.m_operationsChunk = operationsChunk;
        this.m_queueStatus = queueStatus;
    }

    /**
     * Initializes a new {@link MessageData}.
     * @param operationsChunk
     * @param queueStatus
     * @param clientId
     */
    public MessageData(MessageChunk operationsChunk, ConnectionStatus queueStatus, JSONObject jsonData) {
        super();

        this.m_operationsChunk = operationsChunk;
        this.m_queueStatus = queueStatus;
        this.m_jsonData = jsonData;
    }

    /**
     * @return
     */
    public JSONObject toJSON() {
        final JSONObject ret = new JSONObject();

        if (null != m_operationsChunk) {
            ConnectionHelper.appendJSON(ret, m_operationsChunk.toJSON(), true);
        }

        if (null != m_queueStatus) {
            ConnectionHelper.appendJSON(ret, m_queueStatus.toJSON());
        }

        if (null != m_jsonData) {
            ConnectionHelper.appendJSON(ret, m_jsonData);
        }

        return ret;
    }

    /**
     * @param jsonData
     * @return
     */
    static public MessageData createFrom(JSONObject jsonData, ID sender) {
        final MessageChunk operationsChunk = MessageChunk.createFrom(jsonData, sender);
        final ConnectionStatus queueStatus = ConnectionStatus.createFrom(jsonData);

        return new MessageData(operationsChunk, queueStatus, jsonData);
    }

    // - Member ----------------------------------------------------------------
    private MessageChunk m_operationsChunk = null;
    private ConnectionStatus m_queueStatus = null;
    private JSONObject m_jsonData = null;
}
