/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.docx;

import java.io.InputStream;

import org.json.JSONObject;

import com.openexchange.office.DocumentProperties;
import com.openexchange.office.FilterException;
import com.openexchange.office.FilterException.ErrorCode;
import com.openexchange.office.IImporter;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;

/**
 * {@link Importer}
 *
 * @author <a href="mailto:sven.jacobi@open-xchange.com">Sven Jacobi</a>
 */
public class Importer implements IImporter {

    final ServiceLookup services;

    /**
     * Initializes a new {@link Importer}.
     */
    public Importer(ServiceLookup _services) {
        super();
        services = _services;
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.office.IImporter#createOperations(java.io.InputStream)
     */
    @Override
    public JSONObject createOperations(Session session, InputStream inputDocumentStm, DocumentProperties documentProperties)
        throws FilterException {

        try {
            boolean debugGetDefaultDocument = false;
            if(debugGetDefaultDocument) {   // just a simple helper method to store our in memory created
                final OperationDocument emptyDoc = new OperationDocument(services, documentProperties);
                emptyDoc.writeFile("/tmp/default.oxt");    // template documents...
            }
            final OperationDocument operationDocument = new OperationDocument(session, services, inputDocumentStm, null, documentProperties);
            return operationDocument.getOperations();
        }
        catch(Throwable e) {
        	throw OperationDocument.rethrowException(e);
        }
    }

    @Override
    public InputStream getDefaultDocument(String documentTypeName, InputStream templateDocument, DocumentProperties documentProperties)
        throws FilterException {

        if(!documentTypeName.equalsIgnoreCase("text")) {
            throw new FilterException("DOCX getDefaultDocument: filter is only supporting the docx document type", ErrorCode.CRITICAL_ERROR);
        }
        else {
	        if(templateDocument!=null) {
	            return templateDocument;
	        }
	        try {
		        final OperationDocument operationDocument = new OperationDocument(services, documentProperties);
		        return operationDocument.save();
	        }
	        catch(Throwable e) {
	        	throw OperationDocument.rethrowException(e);
	        }
        }
    }
}
