/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

import com.openexchange.office.calcengine.client.CalcEngineClientFactory;
import com.openexchange.office.calcengine.client.CalcEngineClipBoardEvent;
import com.openexchange.office.calcengine.client.CalcEngineDescriptor;
import com.openexchange.office.calcengine.client.ECalcEngineError;
import com.openexchange.office.calcengine.client.ECalcEngineMode;
import com.openexchange.office.calcengine.client.ICalcEngineClient;
import com.openexchange.office.tools.logging.ELogLevel;
import com.openexchange.office.tools.logging.LogFactory;

//=============================================================================
public class CalcEngineErrorSimulator implements ICalcEngineClient
{
    //-------------------------------------------------------------------------
    private static final Log LOG = LogFactory.getJclLog(CalcEngineErrorSimulator.class);

    //-------------------------------------------------------------------------
    public static final String OPERATION_PREFIX     = "sop";
    public static final String OPERATION_4_LOST_DOC = OPERATION_PREFIX+":doclost";
    public static final String OPERATION_4_CRASH    = OPERATION_PREFIX+":crash"  ;

    //-------------------------------------------------------------------------
    private CalcEngineErrorSimulator ()
        throws Exception
    {}
    
    //-------------------------------------------------------------------------
    public synchronized static CalcEngineErrorSimulator create()
        throws Exception
    {
    	return new CalcEngineErrorSimulator ();
    }

    //-------------------------------------------------------------------------
    @Override
    public String createDocument()
        throws Exception
    {
    	INFO("created new document ...");
    	return mem_Impl ().createDocument();
    };
    
    //-------------------------------------------------------------------------
    @Override
    public void destroyDocument(final String sHandle)
        throws Exception
    {
    	mem_Impl ().destroyDocument(sHandle);
    };

    //-------------------------------------------------------------------------
    @Override
    public ECalcEngineError executeOperation(final String       sHandle       ,
                                   			 final String       sOperationJSON,
                                   			 final StringBuffer sResultJSON   )
        throws Exception
    {
        INFO("execute operation ( handle='"+sHandle+"', operations='"+sOperationJSON+"' ) ...");

        // special simulation mode : simulate a missing document ... even if its well known .-)
        
        INFO("... check for OP_LOST_DOC");
        if (impl_isSpecialOp(sOperationJSON, OPERATION_4_LOST_DOC))
        {
        	INFO ("... simulate 'lost document' by returning E_DOCUMENT_LOST !");
        	return ECalcEngineError.E_DOCUMENT_LOST;
        }

        // forward request to "real doc" to see what happen there ...
        // and to simulate e.g. crashes during/after that !
        
        INFO("... forward request to real engine");
        final ECalcEngineError eError = mem_Impl ().executeOperation(sHandle, sOperationJSON, sResultJSON);
        
        // special simulation mode : simulate crash by throwing an exception
        
        INFO("... check for OP_CRASH");
        if (impl_isSpecialOp(sOperationJSON, OPERATION_4_CRASH))
        {
        	INFO ("... simulate 'crash' by throwing runtime exception !");
        	throw new RuntimeException ("Crash was forced by special simulator operation.");
        }
        
        return eError;
    };
    
    //-------------------------------------------------------------------------
    @Override
    public ECalcEngineError restoreDocument (final String    sHandle             ,
			 				                 final String... lPagedOperationJSONs)
        throws Exception
    {
    	return mem_Impl ().restoreDocument(sHandle, lPagedOperationJSONs);
    }

    //-------------------------------------------------------------------------
	@Override
	public ECalcEngineError copy(final String                   sSourceDocHandle,
								 final CalcEngineClipBoardEvent aEvent          )
		throws Exception
	{
    	return mem_Impl ().copy(sSourceDocHandle, aEvent);
	}

    //-------------------------------------------------------------------------
	@Override
	public ECalcEngineError paste(final String                   sTargetDocHandle,
								  final CalcEngineClipBoardEvent aEvent          )
		throws Exception
	{
    	return mem_Impl ().paste(sTargetDocHandle, aEvent);
	}

    //-------------------------------------------------------------------------
    @Override
    public String getVersion()
    {
        return "Calc Engine Simulator 1.0 :-)";
    }

    //-------------------------------------------------------------------------
    @Override
    public void setLogLevel (final ELogLevel eLevel) 
    	throws Exception
    {
    	mem_Impl ().setLogLevel(eLevel);
    }

    //-------------------------------------------------------------------------
    private static boolean impl_isSpecialOp (final String sOp     ,
    										 final String sSpecial)
        throws Exception
    {
    	// we use contains() instead of equals to be prepared for quoting .-)
    	final boolean bIs = StringUtils.containsIgnoreCase(sOp, sSpecial);
    	return bIs;
    }
    
    //-------------------------------------------------------------------------
    private static void INFO (final String sMessage)
        throws Exception
    {
    	//System.out.println (sMessage);
    	LOG.info(sMessage);
    }
    
    //-------------------------------------------------------------------------
    private ICalcEngineClient mem_Impl ()
    	throws Exception
    {
    	if (m_iImpl == null)
    	{
    		final CalcEngineDescriptor aDesc = new CalcEngineDescriptor ();
    		aDesc.m_eMode = ECalcEngineMode.E_NATIVE;
    		m_iImpl = CalcEngineClientFactory.getDirect(aDesc);
    	}
    	return m_iImpl;
    }
    
    //-------------------------------------------------------------------------
    private ICalcEngineClient m_iImpl = null;
}
