/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client;

import java.io.Serializable;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.json.JSONArray;
import org.json.JSONObject;

//=============================================================================
public class CalcEngineClipBoardEvent implements Serializable
{
	//-------------------------------------------------------------------------
	public static final String JSONKEY_USER_SESSION          = "user-session"         ;
	public static final String JSONKEY_CLIPBOARD_HANDLE      = "clipboard-handle"     ;
	public static final String JSONKEY_SOURCE_SELECTION_JSON = "source-selection-json";
	public static final String JSONKEY_TARGET_SELECTION_JSON = "target-selection-json";
	public static final String JSONKEY_COPY_OPERATIONS_JSON  = "copy-operations-json" ;
	public static final String JSONKEY_PASTE_OPERATIONS_JSON = "paste-operations-json";
	
	//-------------------------------------------------------------------------
	private static final long serialVersionUID = 1L;

	//-------------------------------------------------------------------------
	private CalcEngineClipBoardEvent ()
	{}

	//-------------------------------------------------------------------------
	public CalcEngineClipBoardEvent(final CalcEngineClipBoardEvent aSource)
		throws Exception
	{
        super();
        takeOver (aSource);
    }

    //-------------------------------------------------------------------------
	public void takeOver (final CalcEngineClipBoardEvent aSource)
		throws Exception
	{
        sUserSession         = aSource.sUserSession        ;
        sClipboardHandle     = aSource.sClipboardHandle    ;
        sSourceSelectionJSON = aSource.sSourceSelectionJSON;
        sTargetSelectionJSON = aSource.sTargetSelectionJSON;
        sCopyOperationsJSON  = aSource.sCopyOperationsJSON ;
        sPasteOperationsJSON = aSource.sPasteOperationsJSON;
	}
	
    //-------------------------------------------------------------------------
	public static CalcEngineClipBoardEvent NEW ()
	    throws Exception
	{
		final CalcEngineClipBoardEvent aEvent = new CalcEngineClipBoardEvent ();
		return aEvent;
	}

	//-------------------------------------------------------------------------
	public static CalcEngineClipBoardEvent fromJSON (final String sJSON)
	    throws Exception
	{
		final JSONObject               aJSON  = new JSONObject (sJSON);
		final CalcEngineClipBoardEvent aEvent = new CalcEngineClipBoardEvent ();
		
		if (aJSON.hasAndNotNull(JSONKEY_CLIPBOARD_HANDLE))
			aEvent.sClipboardHandle = aJSON.getString(JSONKEY_CLIPBOARD_HANDLE);
		
		if (aJSON.hasAndNotNull(JSONKEY_USER_SESSION))
			aEvent.sUserSession = aJSON.getString(JSONKEY_USER_SESSION);

		if (aJSON.hasAndNotNull(JSONKEY_SOURCE_SELECTION_JSON))
			aEvent.sSourceSelectionJSON = aJSON.getString(JSONKEY_SOURCE_SELECTION_JSON);
		
		if (aJSON.hasAndNotNull(JSONKEY_TARGET_SELECTION_JSON))
			aEvent.sTargetSelectionJSON = aJSON.getString(JSONKEY_TARGET_SELECTION_JSON);
		
		if (aJSON.hasAndNotNull(JSONKEY_COPY_OPERATIONS_JSON))
			aEvent.sCopyOperationsJSON = aJSON.getString(JSONKEY_COPY_OPERATIONS_JSON);
		
		if (aJSON.hasAndNotNull(JSONKEY_PASTE_OPERATIONS_JSON))
			aEvent.sPasteOperationsJSON = aJSON.getString(JSONKEY_PASTE_OPERATIONS_JSON);

		return aEvent;
	}
	
	//-------------------------------------------------------------------------
	public static String toJSON (final CalcEngineClipBoardEvent aEvent)
	    throws Exception
	{
		final JSONObject aJSON = new JSONObject ();

		if ( ! StringUtils.isEmpty(aEvent.sClipboardHandle))
			aJSON.put(JSONKEY_CLIPBOARD_HANDLE, aEvent.sClipboardHandle);

		if ( ! StringUtils.isEmpty(aEvent.sUserSession))
			aJSON.put(JSONKEY_USER_SESSION, aEvent.sUserSession);

		if ( ! StringUtils.isEmpty(aEvent.sSourceSelectionJSON))
			aJSON.put(JSONKEY_SOURCE_SELECTION_JSON, aEvent.sSourceSelectionJSON);

		if ( ! StringUtils.isEmpty(aEvent.sTargetSelectionJSON))
			aJSON.put(JSONKEY_TARGET_SELECTION_JSON, aEvent.sTargetSelectionJSON);

		if ( ! StringUtils.isEmpty(aEvent.sCopyOperationsJSON))
			aJSON.put(JSONKEY_COPY_OPERATIONS_JSON, aEvent.sCopyOperationsJSON);

		if ( ! StringUtils.isEmpty(aEvent.sPasteOperationsJSON))
			aJSON.put(JSONKEY_PASTE_OPERATIONS_JSON, aEvent.sPasteOperationsJSON);

        final String sJson = aJSON.toString();
        return sJson;
	}

	//-------------------------------------------------------------------------
    /* {operation:[name:'copy', selection:{...}]}
     */
	public static String toJSON4CopyEvent (final CalcEngineClipBoardEvent aCopyEvent)
	    throws Exception
	{
		Validate.notEmpty(aCopyEvent.sSourceSelectionJSON, "Miss event parameter 'operation-selection'.");

		JSONObject aOpValue   = new JSONObject ();
		JSONObject aSelection = new JSONObject (aCopyEvent.sSourceSelectionJSON);
		
		aOpValue.put("name" , "copy"                 );
		aOpValue.put("start", aSelection.get("start"));
        aOpValue.put("sheet", aSelection.get("sheet"));

        if(aSelection.has("end"))
            aOpValue.put("end", aSelection.get("end"));

	    JSONArray aOps = new JSONArray ();
	    aOps.put (aOpValue);

	    JSONObject aOp = new JSONObject ();
	    aOp.put("operations", aOps);
		
		return aOp.toString();
	}

    //-------------------------------------------------------------------------
	public static String toJSON4PasteEvent (final CalcEngineClipBoardEvent aPasteEvent)
	    throws Exception
	{
		Validate.notEmpty(aPasteEvent.sTargetSelectionJSON, "Miss event parameter 'target-selection'.");
		Validate.notEmpty(aPasteEvent.sCopyOperationsJSON , "Miss event parameter 'copy-operations'." );

		JSONObject aOpValue   = new JSONObject ();
        JSONObject aSelection = new JSONObject (aPasteEvent.sTargetSelectionJSON);

		aOpValue.put("name" , "paste"                );
        aOpValue.put("start", aSelection.get("start"));
        aOpValue.put("sheet", aSelection.get("sheet"));
		aOpValue.put("data" , new JSONObject(aPasteEvent.sCopyOperationsJSON ));

        if(aSelection.has("end"))
            aOpValue.put("end", aSelection.get("end"));

	    JSONArray aOps = new JSONArray ();
	    aOps.put (aOpValue);

	    JSONObject aOp = new JSONObject ();
	    aOp.put("operations", aOps);

	    return aOp.toString();
	}

	//-------------------------------------------------------------------------
	@Override
	public String toString ()
	{
		StringBuffer sString = new StringBuffer (256);
		sString.append (super.toString ()                               );
		sString.append (" : {"                                          );
		sString.append (" user session = '"    +sUserSession        +"'");
		sString.append (" clipboard handle = '"+sClipboardHandle    +"'");
		sString.append (" source selection = '"+sSourceSelectionJSON+"'");
		sString.append (" target selection = '"+sTargetSelectionJSON+"'");
		sString.append (" copy operations = '" +sCopyOperationsJSON +"'");
		sString.append (" paste operations = '"+sPasteOperationsJSON+"'");
		sString.append (" }"                                            );
		return sString.toString ();
	}

	//-------------------------------------------------------------------------
	/** an (unique) id for the outside user session where we bound our clip board too ...
	 *  <p>
	 *  Our clip board is a "single-entry-user-clip-board". Every new copy event
	 *  will replace any existing old copy data .. and that has to be organized ..
	 *  and needs a correlation to the user.
	 *  </p>
	 */
	public String sUserSession = null;
	
	//-------------------------------------------------------------------------
	/** the server side handler where the corresponding clip board data are cached.
	 *  <p>
	 *  Is the return value of the 'copy' event and needs to be define
	 *  for every further 'paste' event.
	 *  </p>
	 */
	public String sClipboardHandle = null;
	
	//-------------------------------------------------------------------------
	/** the JSON object where the 'source ranges / selection(s)' are stored.
	 *  <p>
	 *  Used within the 'copy' event only
	 *  </p>
	 */
	public String sSourceSelectionJSON = null;
	
	//-------------------------------------------------------------------------
	/** the JSON object where the 'target ranges / selection(s)' are stored.
	 *  <p>
	 *  Used within the 'paste' event only
	 *  </p>
	 */
	public String sTargetSelectionJSON = null;

	//-------------------------------------------------------------------------
	/** the set of document operations as a result of the copy event used
	 *  at the following paste (given as JSON).
	 *  <p>
	 *  This is an internal variable - not to be thought as IN nor as OUT parameter.
	 *  It will be used to transport those data from the core to the place
	 *  where caching will be done only .-)
	 *  </p>
	 */
	public String sCopyOperationsJSON = null;

	//-------------------------------------------------------------------------
	/** the set of operations to visualize the paste operation on the client (given as JSON).
	 *  <p>
	 *  Is an OUT parameter for a 'paste' event.
	 *  </p>
	 */
	public String sPasteOperationsJSON = null;
}