/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.scripts.DefaultScriptProcessor;
import org.apache.fop.complexscripts.scripts.DevanagariScriptProcessor;
import org.apache.fop.complexscripts.scripts.GujaratiScriptProcessor;
import org.apache.fop.complexscripts.scripts.GurmukhiScriptProcessor;
import org.apache.fop.complexscripts.scripts.ScriptProcessor;
import org.apache.fop.complexscripts.util.CharScript;
import org.apache.fop.complexscripts.util.GlyphContextTester;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndicScriptProcessor
extends DefaultScriptProcessor {
    private static final Log log = LogFactory.getLog(IndicScriptProcessor.class);
    private static final String[] gsubReqFeatures = new String[]{"abvf", "abvs", "akhn", "blwf", "blws", "ccmp", "cjct", "clig", "half", "haln", "locl", "nukt", "pref", "pres", "pstf", "psts", "rkrf", "rphf", "vatu"};
    private static final String[] gsubOptFeatures = new String[]{"afrc", "calt", "dlig"};
    private static final String[] gposReqFeatures = new String[]{"abvm", "blwm", "dist", "kern"};
    private static final String[] gposOptFeatures = new String[0];
    private final ScriptContextTester subContextTester = new SubstitutionScriptContextTester();
    private final ScriptContextTester posContextTester = new PositioningScriptContextTester();
    private static Set<String> basicShapingFeatures;
    private static final String[] basicShapingFeatureStrings;
    private static Set<String> presentationFeatures;
    private static final String[] presentationFeatureStrings;

    public static ScriptProcessor makeProcessor(String script) {
        switch (CharScript.scriptCodeFromTag(script)) {
            case 315: 
            case 1315: {
                return new DevanagariScriptProcessor(script);
            }
            case 320: 
            case 1320: {
                return new GujaratiScriptProcessor(script);
            }
            case 310: 
            case 1310: {
                return new GurmukhiScriptProcessor(script);
            }
        }
        return new IndicScriptProcessor(script);
    }

    IndicScriptProcessor(String script) {
        super(script);
    }

    @Override
    public String[] getSubstitutionFeatures() {
        return gsubReqFeatures;
    }

    @Override
    public String[] getOptionalSubstitutionFeatures() {
        return gsubOptFeatures;
    }

    @Override
    public ScriptContextTester getSubstitutionContextTester() {
        return this.subContextTester;
    }

    @Override
    public String[] getPositioningFeatures() {
        return gposReqFeatures;
    }

    @Override
    public String[] getOptionalPositioningFeatures() {
        return gposOptFeatures;
    }

    @Override
    public ScriptContextTester getPositioningContextTester() {
        return this.posContextTester;
    }

    @Override
    public GlyphSequence substitute(GlyphSequence gs, String script, String language, GlyphTable.UseSpec[] usa, ScriptContextTester sct) {
        assert (usa != null);
        GlyphSequence[] sa = this.syllabize(gs, script, language);
        int n = sa.length;
        for (int i = 0; i < n; ++i) {
            GlyphSequence s = sa[i];
            for (GlyphTable.UseSpec us : usa) {
                if (!this.isBasicShapingUse(us)) continue;
                s.setPredications(true);
                s = us.substitute(s, script, language, sct);
            }
            s = this.reorderPreBaseMatra(s);
            s = this.reorderReph(s);
            int m = usa.length;
            for (int j = 0; j < m; ++j) {
                GlyphTable.UseSpec us;
                us = usa[j];
                if (!this.isPresentationUse(us)) continue;
                s.setPredications(true);
                s = us.substitute(s, script, language, sct);
            }
            sa[i] = s;
        }
        return this.unsyllabize(gs, sa);
    }

    protected Class<? extends Syllabizer> getSyllabizerClass() {
        return null;
    }

    private GlyphSequence[] syllabize(GlyphSequence gs, String script, String language) {
        return Syllabizer.getSyllabizer(script, language, this.getSyllabizerClass()).syllabize(gs);
    }

    private GlyphSequence unsyllabize(GlyphSequence gs, GlyphSequence[] sa) {
        return GlyphSequence.join(gs, sa);
    }

    private boolean isBasicShapingUse(GlyphTable.UseSpec us) {
        assert (us != null);
        if (basicShapingFeatures != null) {
            return basicShapingFeatures.contains(us.getFeature());
        }
        return false;
    }

    private boolean isPresentationUse(GlyphTable.UseSpec us) {
        assert (us != null);
        if (presentationFeatures != null) {
            return presentationFeatures.contains(us.getFeature());
        }
        return false;
    }

    private GlyphSequence reorderPreBaseMatra(GlyphSequence gs) {
        int target;
        int source = this.findPreBaseMatra(gs);
        if (source >= 0 && (target = this.findPreBaseMatraTarget(gs, source)) >= 0 && target != source) {
            gs = this.reorder(gs, source, target);
        }
        return gs;
    }

    protected int findPreBaseMatra(GlyphSequence gs) {
        return -1;
    }

    protected int findPreBaseMatraTarget(GlyphSequence gs, int source) {
        return -1;
    }

    private GlyphSequence reorderReph(GlyphSequence gs) {
        int target;
        int source = this.findReph(gs);
        if (source >= 0 && (target = this.findRephTarget(gs, source)) >= 0 && target != source) {
            gs = this.reorder(gs, source, target);
        }
        return gs;
    }

    protected int findReph(GlyphSequence gs) {
        return -1;
    }

    protected int findRephTarget(GlyphSequence gs, int source) {
        return -1;
    }

    private GlyphSequence reorder(GlyphSequence gs, int source, int target) {
        return GlyphSequence.reorder(gs, source, 1, target);
    }

    @Override
    public boolean position(GlyphSequence gs, String script, String language, int fontSize, GlyphTable.UseSpec[] usa, int[] widths, int[][] adjustments, ScriptContextTester sct) {
        boolean adjusted = super.position(gs, script, language, fontSize, usa, widths, adjustments, sct);
        return adjusted;
    }

    static {
        basicShapingFeatureStrings = new String[]{"abvf", "akhn", "blwf", "cjct", "half", "locl", "nukt", "pref", "pstf", "rkrf", "rphf", "vatu"};
        basicShapingFeatures = new HashSet<String>();
        for (String s : basicShapingFeatureStrings) {
            basicShapingFeatures.add(s);
        }
        presentationFeatureStrings = new String[]{"abvs", "blws", "calt", "haln", "pres", "psts"};
        presentationFeatures = new HashSet<String>();
        for (String s : presentationFeatureStrings) {
            presentationFeatures.add(s);
        }
    }

    protected static class Segment {
        static final int OTHER = 0;
        static final int SYLLABLE = 1;
        private int start;
        private int end;
        private int type;

        Segment(int start, int end, int type) {
            this.start = start;
            this.end = end;
            this.type = type;
        }

        int getStart() {
            return this.start;
        }

        int getEnd() {
            return this.end;
        }

        int getOffset() {
            return this.start;
        }

        int getCount() {
            return this.end - this.start;
        }

        int getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DefaultSyllabizer
    extends Syllabizer {
        DefaultSyllabizer(String script, String language) {
            super(script, language);
        }

        @Override
        GlyphSequence[] syllabize(GlyphSequence gs) {
            int[] ca = gs.getCharacterArray(false);
            int nc = gs.getCharacterCount();
            if (nc == 0) {
                return new GlyphSequence[]{gs};
            }
            return this.segmentize(gs, this.segmentize(ca, nc));
        }

        protected Segment[] segmentize(int[] ca, int nc) {
            Vector<Segment> sv = new Vector<Segment>(nc);
            int s = 0;
            int e = nc;
            while (s < e) {
                int i = this.findStartOfSyllable(ca, s, e);
                if (i > s) {
                    sv.add(new Segment(s, i, 0));
                    s = i;
                } else if (i > s) {
                    sv.add(new Segment(s, e, 0));
                    s = e;
                }
                i = this.findEndOfSyllable(ca, s, e);
                if (i > s) {
                    sv.add(new Segment(s, i, 1));
                    s = i;
                    continue;
                }
                sv.add(new Segment(s, e, 0));
                s = e;
            }
            return sv.toArray(new Segment[sv.size()]);
        }

        protected GlyphSequence[] segmentize(GlyphSequence gs, Segment[] sa) {
            int ng = gs.getGlyphCount();
            int[] ga = gs.getGlyphArray(false);
            GlyphSequence.CharAssociation[] aa = gs.getAssociations(0, -1);
            Vector<GlyphSequence> nsv = new Vector<GlyphSequence>();
            for (Segment s : sa) {
                Vector<Integer> ngv = new Vector<Integer>(ng);
                Vector<GlyphSequence.CharAssociation> nav = new Vector<GlyphSequence.CharAssociation>(ng);
                for (int j = 0; j < ng; ++j) {
                    GlyphSequence.CharAssociation ca = aa[j];
                    if (!ca.contained(s.getOffset(), s.getCount())) continue;
                    ngv.add(ga[j]);
                    nav.add(ca);
                }
                if (ngv.size() <= 0) continue;
                nsv.add(new GlyphSequence(gs, null, DefaultSyllabizer.toIntArray(ngv), null, null, nav.toArray(new GlyphSequence.CharAssociation[nav.size()]), null));
            }
            if (nsv.size() > 0) {
                return nsv.toArray(new GlyphSequence[nsv.size()]);
            }
            return new GlyphSequence[]{gs};
        }

        protected int findStartOfSyllable(int[] ca, int s, int e) {
            return e;
        }

        protected int findEndOfSyllable(int[] ca, int s, int e) {
            return s;
        }

        private static int[] toIntArray(Vector<Integer> iv) {
            int ni = iv.size();
            int[] ia = new int[iv.size()];
            int n = ni;
            for (int i = 0; i < n; ++i) {
                ia[i] = iv.get(i);
            }
            return ia;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class Syllabizer
    implements Comparable {
        private String script;
        private String language;
        private static Map<String, Syllabizer> syllabizers = new HashMap<String, Syllabizer>();

        Syllabizer(String script, String language) {
            this.script = script;
            this.language = language;
        }

        abstract GlyphSequence[] syllabize(GlyphSequence var1);

        public int hashCode() {
            int hc = 0;
            hc = 7 * hc + (hc ^ this.script.hashCode());
            hc = 11 * hc + (hc ^ this.language.hashCode());
            return hc;
        }

        public boolean equals(Object o) {
            if (o instanceof Syllabizer) {
                Syllabizer s = (Syllabizer)o;
                if (!s.script.equals(this.script)) {
                    return false;
                }
                return s.language.equals(this.language);
            }
            return false;
        }

        public int compareTo(Object o) {
            int d;
            if (o instanceof Syllabizer) {
                Syllabizer s = (Syllabizer)o;
                d = this.script.compareTo(s.script);
                if (d == 0) {
                    d = this.language.compareTo(s.language);
                }
            } else {
                d = -1;
            }
            return d;
        }

        static Syllabizer getSyllabizer(String script, String language, Class<? extends Syllabizer> syllabizerClass) {
            String sid = Syllabizer.makeSyllabizerId(script, language);
            Syllabizer s = syllabizers.get(sid);
            if (s == null) {
                s = Syllabizer.makeSyllabizer(script, language, syllabizerClass);
                if (s == null) {
                    s = new DefaultSyllabizer(script, language);
                }
                syllabizers.put(sid, s);
            }
            return s;
        }

        static String makeSyllabizerId(String script, String language) {
            return script + ":" + language;
        }

        static Syllabizer makeSyllabizer(String script, String language, Class<? extends Syllabizer> syllabizerClass) {
            Syllabizer s;
            try {
                Constructor<? extends Syllabizer> cf = syllabizerClass.getDeclaredConstructor(String.class, String.class);
                s = cf.newInstance(script, language);
            }
            catch (NoSuchMethodException e) {
                s = null;
            }
            catch (InstantiationException e) {
                s = null;
            }
            catch (IllegalAccessException e) {
                s = null;
            }
            catch (InvocationTargetException e) {
                s = null;
            }
            return s;
        }
    }

    private static class PositioningScriptContextTester
    implements ScriptContextTester {
        private static Map testerMap = new HashMap();

        private PositioningScriptContextTester() {
        }

        public GlyphContextTester getTester(String feature) {
            return (GlyphContextTester)testerMap.get(feature);
        }
    }

    private static class SubstitutionScriptContextTester
    implements ScriptContextTester {
        private static Map testerMap = new HashMap();

        private SubstitutionScriptContextTester() {
        }

        public GlyphContextTester getTester(String feature) {
            return (GlyphContextTester)testerMap.get(feature);
        }
    }
}

