/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.jobpool;

import java.util.HashMap;
import java.util.Map;

import com.openexchange.office.tools.jobpool.impl.JobPool;

//=============================================================================
/** manage all job pools available within the same runtime.
 *  Every pool has it's own ID. How those IDs are distinguished ... ?
 *  No idea yet .-)
 */
public class JobPoolManager
{
	//-------------------------------------------------------------------------
	/** force using of our static access method !
	 */
	private JobPoolManager ()
	{}
	
	//-------------------------------------------------------------------------
	/** @return access to a functional job pool.
	 * 
	 *  All jobs within the same pool are from the same "type".
	 *  But different pools can support different types of jobs.
	 * 
	 *	@param	aJobType [IN]
	 *			the kind of jobs supported by that pool.
	 */
	public static synchronized IJobPool accessPool (final Class< ? extends JobBase > aJobType)
		throws Exception
	{
		final String                 sJobType = aJobType.getName();
		final Map< String, JobPool > lPools   = mem_Pools ();
		      JobPool                aPool    = null;
		      
		if (lPools.containsKey(sJobType))
		{
			aPool = lPools.get(sJobType);
		}
		else
		{
			aPool = new JobPool ();
			aPool.setJobType(aJobType);

			impl_configurePool (aPool);
			
			lPools.put (sJobType, aPool);
		}
		
		return aPool;
	}
	
	//-------------------------------------------------------------------------
	/** prepared for the future !
	 *  Use it to initialize every new created pool one times only ...
	 *  e.g. to define it's pools size
	 * 
	 *  @param	iPool [IN]
	 *  		the pool to be initialized
	 */
	private static void impl_configurePool (final JobPool aPool)
	    throws Exception
	{
		// TODO implement me
	}
	
	//-------------------------------------------------------------------------
	private static Map< String, JobPool > mem_Pools ()
	    throws Exception
	{
		if (m_lPools == null)
			m_lPools = new HashMap< String, JobPool > ();
		return m_lPools;
	}
	
	//-------------------------------------------------------------------------
	private static Map< String, JobPool > m_lPools = null;
}
