/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.realtime.impl;

import java.util.ArrayList;
import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;
/**
*
* @author Oliver Specht<oliver.specht@open-xchange.com>
* merges the resulting changed rows or columns of the results of consecutive executes of the CalcEngine
*/

public class RowColsMerger {
    ArrayList<RowColRange> ranges = new ArrayList<RowColRange>();
public RowColsMerger( JSONArray globalRowCols ) {
    Iterator<Object> cellsIter = globalRowCols.iterator();
    while(cellsIter.hasNext()) {
        JSONObject range = (JSONObject)cellsIter.next();
        ranges.add(new RowColRange(range));
    }
}
public void add( JSONArray localRowCols ) {
    Iterator<Object> cellsIter = localRowCols.iterator();
    while(cellsIter.hasNext()) {
        Iterator<RowColRange> rangeIter = ranges.iterator();
        boolean isMerged = false;
        JSONObject range = (JSONObject)cellsIter.next();
        RowColRange newRange = new RowColRange(range);
        while(rangeIter.hasNext() && !isMerged)
        {
            RowColRange next = rangeIter.next();
            isMerged = next.merge(newRange);
        }
        if(!isMerged)
            ranges.add(newRange);
    }
}
public JSONArray getRowCols() {
    JSONArray ret = new JSONArray();
    Iterator<RowColRange> rangeIter = ranges.iterator();
    boolean isMerged = false;
    while(rangeIter.hasNext() && !isMerged)
    {
        RowColRange next = rangeIter.next();
        ret.put(next.write());
    }
    return ret;
}
}
