package com.openexchange.office.calcengine.client.impl.jms;

import javax.jms.Message;

public class CalcEngineJMSRequest extends CalcEngineJMSMessage
{
    //-------------------------------------------------------------------------
	public static final String REQUEST_PROP_PREFIX = CalcEngineJMSMessage.HEADER_PROP_PREFIX+".request";

    //-------------------------------------------------------------------------
	public static final String REQUEST_PROP_METHOD                = REQUEST_PROP_PREFIX+".method";
	public static final String REQUEST_PROP_JSON_OPERATIONREQUEST = REQUEST_PROP_PREFIX+".json-operation-request";

    //-------------------------------------------------------------------------
	private CalcEngineJMSRequest ()
	{}

    //-------------------------------------------------------------------------
	public static CalcEngineJMSRequest create ()
	    throws Exception
	{
		return new CalcEngineJMSRequest ();
	}

	//-------------------------------------------------------------------------
	@Override
    public void fromJMSMessage (final Message aMessage)
	    throws Exception
	{
		super.fromJMSMessage(aMessage);

		final String            sMethod = aMessage.getStringProperty (REQUEST_PROP_METHOD);
		final ECalcEngineMethod eMethod = ECalcEngineMethod.fromString (sMethod);
		setMethod (eMethod);

		final String sJSONOperationRequest = aMessage.getStringProperty (REQUEST_PROP_JSON_OPERATIONREQUEST);
		setJSONOperationRequest (sJSONOperationRequest);
	}

	//-------------------------------------------------------------------------
	@Override
    public void toJMSMessage (final Message aMessage)
	    throws Exception
	{
		super.toJMSMessage (aMessage);

		final ECalcEngineMethod eMethod = getMethod ();
		final String            sMethod = ECalcEngineMethod.toString(eMethod);
		aMessage.setStringProperty (REQUEST_PROP_METHOD, sMethod);

		final String sJSONOperationRequest = getJSONOperationRequest ();
		aMessage.setStringProperty (REQUEST_PROP_JSON_OPERATIONREQUEST, sJSONOperationRequest);
	}

	//-------------------------------------------------------------------------
	public void setMethod (final ECalcEngineMethod eMethod)
	    throws Exception
	{
		m_eMethod = eMethod;
	}

	//-------------------------------------------------------------------------
	public ECalcEngineMethod getMethod ()
	    throws Exception
	{
		return m_eMethod;
	}

	//-------------------------------------------------------------------------
	public void setJSONOperationRequest (final String sJSON)
	    throws Exception
	{
		m_sJSONOperationRequest = sJSON;
	}

	//-------------------------------------------------------------------------
	public String getJSONOperationRequest ()
	    throws Exception
	{
		return m_sJSONOperationRequest;
	}

	//-------------------------------------------------------------------------
	private ECalcEngineMethod m_eMethod = null;

	//-------------------------------------------------------------------------
	private String m_sJSONOperationRequest = null;
}
