/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.modca.ResourceObject;
import org.apache.fop.afp.parser.MODCAParser;
import org.apache.fop.afp.parser.UnparsedStructuredField;

public final class AFPResourceUtil {
    private static final byte TYPE_CODE_BEGIN = -88;
    private static final byte TYPE_CODE_END = -87;
    private static final Log LOG = LogFactory.getLog(AFPResourceUtil.class);

    private AFPResourceUtil() {
    }

    public static byte[] getNext(byte[] identifier, InputStream inputStream) throws IOException {
        UnparsedStructuredField field;
        MODCAParser parser = new MODCAParser(inputStream);
        do {
            if ((field = parser.readNextStructuredField()) != null) continue;
            return null;
        } while (field.getSfClassCode() != identifier[0] || field.getSfTypeCode() != identifier[1] || field.getSfCategoryCode() != identifier[2]);
        return field.getCompleteFieldAsBytes();
    }

    private static String getResourceName(UnparsedStructuredField field) throws UnsupportedEncodingException {
        byte[] nameBytes = new byte[8];
        byte[] fieldData = field.getData();
        if (fieldData.length < 8) {
            throw new IllegalArgumentException("Field data does not contain a resource name");
        }
        System.arraycopy(fieldData, 0, nameBytes, 0, 8);
        return new String(nameBytes, "Cp1146");
    }

    public static void copyResourceFile(InputStream in, OutputStream out) throws IOException {
        UnparsedStructuredField field;
        MODCAParser parser = new MODCAParser(in);
        while ((field = parser.readNextStructuredField()) != null) {
            out.write(90);
            field.writeTo(out);
        }
    }

    public static void copyNamedResource(String name, InputStream in, final OutputStream out) throws IOException {
        boolean wrapInResource;
        UnparsedStructuredField field;
        final MODCAParser parser = new MODCAParser(in);
        HashSet<String> resourceNames = new HashSet<String>();
        while (true) {
            if ((field = parser.readNextStructuredField()) == null) {
                throw new IOException("Requested resource '" + name + "' not found. Encountered resource names: " + resourceNames);
            }
            if (field.getSfTypeCode() != -88) continue;
            String resourceName = AFPResourceUtil.getResourceName(field);
            resourceNames.add(resourceName);
            if (resourceName.equals(name)) break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Start of requested structured field found:\n" + field));
        }
        final UnparsedStructuredField fieldBegin = field;
        if (fieldBegin.getSfCategoryCode() == 95) {
            wrapInResource = true;
        } else if (fieldBegin.getSfCategoryCode() == -50) {
            wrapInResource = false;
        } else {
            throw new IOException("Cannot handle resource: " + fieldBegin);
        }
        if (wrapInResource) {
            ResourceObject resourceObject = new ResourceObject(name){

                protected void writeContent(OutputStream os) throws IOException {
                    AFPResourceUtil.copyNamedStructuredFields(this.name, fieldBegin, parser, out);
                }
            };
            resourceObject.setType((byte)-5);
            resourceObject.writeToStream(out);
        } else {
            AFPResourceUtil.copyNamedStructuredFields(name, fieldBegin, parser, out);
        }
    }

    private static void copyNamedStructuredFields(String name, UnparsedStructuredField fieldBegin, MODCAParser parser, OutputStream out) throws IOException {
        UnparsedStructuredField field = fieldBegin;
        while (true) {
            if (field == null) {
                throw new IOException("Ending structured field not found for resource " + name);
            }
            out.write(90);
            field.writeTo(out);
            if (field.getSfTypeCode() == -87 && fieldBegin.getSfCategoryCode() == field.getSfCategoryCode() && name.equals(AFPResourceUtil.getResourceName(field))) break;
            field = parser.readNextStructuredField();
        }
    }
}

