/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.office.calcengine.worker;

import com.openexchange.office.tools.commandline.CommandLineBase;
import org.apache.commons.lang.Validate;

public class WorkerCommandLine
extends CommandLineBase {
    public static final String OPT_SHORT_PORT = "p";
    public static final String OPT_LONG_PORT = "port";
    public static final String OPT_SHORT_INTERFACE = "i";
    public static final String OPT_LONG_INTERFACE = "interface";
    public static final String OPT_SHORT_SIMULATE = "s";
    public static final String OPT_LONG_SIMULATE = "simulate";

    public WorkerCommandLine() throws Exception {
        super("calc-engine-worker");
        this.addOption(OPT_SHORT_PORT, OPT_LONG_PORT, true, true, "port used for incoming connections.");
        this.addOption(OPT_SHORT_INTERFACE, OPT_LONG_INTERFACE, true, false, "network interface used for incoming connections.Default is 0.0.0.0 for local and remote connections.");
        this.addOption(OPT_SHORT_SIMULATE, OPT_LONG_SIMULATE, false, false, "enable special simulation mode.In those mode no C++ code is called!All operation will be simulated.Not thought for real production mode.");
    }

    protected void verifyInt() throws Exception {
        int nPort = this.getPort();
        Validate.isTrue((nPort > 0 ? 1 : 0) != 0, (String)"Port has to be > 0.");
    }

    public int getPort() throws Exception {
        String sPort = this.getOptionValue(OPT_SHORT_PORT);
        int nPort = Integer.parseInt(sPort);
        return nPort;
    }

    public String getInterface() throws Exception {
        String sInterface = this.getOptionValue(OPT_SHORT_INTERFACE);
        return sInterface;
    }

    public boolean isSimulationOn() throws Exception {
        boolean bIsSimulationOn = this.hasOption(OPT_SHORT_SIMULATE);
        return bIsSimulationOn;
    }
}

