/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/gridlinemodel',
    ['io.ox/office/editframework/model/format/attributedmodel',
     'io.ox/office/drawinglayer/view/chartstyleutil'
    ], function (AttributedModel, ChartStyleUtil) {

    'use strict';

    // class GridlineModel =====================================================

    /**
     * visualisation model for chart axes,
     * it defines colors and textual colors
     */
    function GridlineModel(chart, attrs, dataAxis) {

        // base constructor ---------------------------------------------------

        AttributedModel.call(this, chart.getApp(), attrs, { additionalFamilies: ['line'] });

        // methods ------------------------------------------------------------

        this.refreshInfo = function () {
            var att = this.getMergedAttributes();
            if (!dataAxis) {
                return;
            }

            ChartStyleUtil.handleLineProps(chart, att.line, dataAxis, 'grid');
        };


    } // class GridlineModel

    // exports ================================================================
    return AttributedModel.extend({ constructor: GridlineModel });

});
