/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/portal/action/toolbaractionstext',
    ['gettext!io.ox/office/portal',
        'io.ox/core/extensions',
        'io.ox/core/extPatterns/links',
        'io.ox/backbone/mini-views/dropdown',
        'io.ox/office/portal/utils',
        'io.ox/core/capabilities'
    ], function (gt, Ext, Links, Dropdown, Utils) {

        'use strict';

        /**
         * Creates all extensions points and bind actions for the portal toolbar.
         *
         * @constructor
         *
         */
        var ToolbarActionsText = function () {

            var // identifier for the text toolbar
                toolbarPointId = 'io.ox/office/portal/toolbartext',
                // the name of the application, used for filtering files in file picker
                appBaseName = 'text',
                // whether this is an Android device with reduced functionality
                isAndroid = _.browser.Android;

            this.toolbarPoint = Ext.point(toolbarPointId);

            if (!isAndroid) {

                // add link to the toolbar point
                this.toolbarPoint.extend({
                    id: 'new-textdocument',
                    index: 100,
                    draw: function (baton) {
                        Ext.point(toolbarPointId + '/new').invoke('draw', this, baton);
                    }
                });

                // create extension point for the 'new text document' link
                Ext.point(toolbarPointId + '/new').extend(new Links.Link({
                    id: 'new_text',
                    index: 100,
                    prio: 'hi',
                    label: gt('New Text Document'),
                    cssClasses: 'new-document',
                    ref: toolbarPointId + '/actions/new/text'
                }));

                new Links.Action(toolbarPointId + '/actions/new/text', {
                    capabilities: 'text',
                    action: function (baton) {
                        ox.launch('io.ox/office/text/main', { action: 'new', folderId: baton.app.folder.get() });
                    }
                });
            }

            //add open document link to  the toolbar point
            this.toolbarPoint.extend(new Links.Link({
                id: 'open-textdocument',
                index: 200,
                prio: 'hi',
                label: gt('Open Text Document'),
                cssClasses: 'open-document',
                ref: 'io.ox/office/portal/opentext'
            }));

            new Links.Action('io.ox/office/portal/opentext', {
                action: function () {
                    require(['io.ox/files/filepicker']).done(function (Picker) {
                        new Picker({
                            // prefix for custom ext. point
                            point: 'io.ox/office/portal/toolbar/open',
                            // filter files of disabled applications (capabilities)
                            filter: function (file) {
                                return appBaseName === Utils.getAppBaseName(file.filename);
                            },
                            primaryButtonText: gt('Open'),
                            cancelButtonText: gt('Cancel'),
                            header: gt('Open document'),
                            multiselect: false
                        })
                        .done(function (files) {
                            // get single file in array (multiselect false)
                            if (files && files[0]) {
                                var selectedFile = files[0],
                                    moduleName = Utils.getModuleName(selectedFile.filename);
                                ox.launch(moduleName + '/main', { action: 'load', file: selectedFile });
                            }
                        });
                    });
                }
            });

        };

        return new ToolbarActionsText();

    });
