/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/model/documentmodel', ['io.ox/files/api'], function (FilesAPI) {

    'use strict';

    var documentModel = Backbone.Model.extend({

        defaults : function () {
            return {
                previewWidth: 40
            };
        },

        initialize: function () {

            this.set('previewURL', FilesAPI.getUrl(this.attributes, 'preview'));

        }

    });

    return documentModel;

});