/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2014 Open-Xchange Inc., Tarrytown, NY, USA. info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/collection/templatecollection',
    ['io.ox/office/portal/model/templatemodel',
        'io.ox/office/tk/io'
    ], function (TemplateModel, IO) {

        'use strict';

        var templateCollection = Backbone.Collection.extend({

            model : TemplateModel,

            templatesDef : $.Deferred(),

            initialize: function () {

                var self = this;

                // retrieve template list from Template Manager
                this.templatesDef = IO.sendRequest({
                    module: 'oxodocumentfilter',
                    params: {
                        action: 'gettemplatelist',
                        type: 'all'
                    }
                }).done(function (data) {
                    var templateList = data.templates || [];
                    // populate the collection with templates
                    _.each(templateList, function (template) {
                        self.add(new TemplateModel(template), {merge: true});
                    });
                }).fail(function () {
                    console.error('Error: failed loading document templates.');
                });

                // debugging
                //window.templates = this;

            }

            // sort documents automatically by their last opened timestamp, descending.
//            comparator: function (model) {
//                return model;
//            }

        });

        return templateCollection;

    });
