/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/model/basemodel',
     ['io.ox/office/tk/object/triggerobject'
     ], function (TriggerObject) {

    'use strict';

    // class BaseModel ========================================================

    /**
     * The base class for model classes used in OX Documents applications.
     *
     * @constructor
     *
     * @extends TriggerObject
     *
     * @param {BaseApplication} app
     *  The application that has created this model instance.
     */
    function BaseModel(/*app*/) {

        // base constructor ---------------------------------------------------

        TriggerObject.call(this);

    } // class BaseModel

    // exports ================================================================

    // derive this class from class TriggerObject
    return TriggerObject.extend({ constructor: BaseModel });

});
