var handlebars = require("./handlebars/base"),

// Each of these augment the Handlebars object. No need to setup here.
// (This is done to easily share code between commonjs and browse envs)
  utils = require("./handlebars/utils"),
  compiler = require("./handlebars/compiler"),
  runtime = require("./handlebars/runtime");

var create = function() {
  var hb = handlebars.create();

  utils.attach(hb);
  compiler.attach(hb);
  runtime.attach(hb);

  return hb;
};

var Handlebars = create();
Handlebars.create = create;

module.exports = Handlebars; // instantiate an instance

// Publish a Node.js require() handler for .handlebars and .hbs files
if (require.extensions) {
  var extension = function(module, filename) {
    var fs = require("fs");
    var templateString = fs.readFileSync(filename, "utf8");
    module.exports = Handlebars.compile(templateString);
  };
  require.extensions[".handlebars"] = extension;
  require.extensions[".hbs"] = extension;
}

// BEGIN(BROWSER)

// END(BROWSER)

// USAGE:
// var handlebars = require('handlebars');

// var singleton = handlebars.Handlebars,
//  local = handlebars.create();
