define('oxguard/settings/pane',
    ['io.ox/core/extensions', 'io.ox/core/tk/dialogs', 'oxguard/crypto/encr',
       'gettext!oxguard/settings/pane'], function (ext, dialogs, encr, gt) {
    'use strict';

    
    function createPasswordChange() {
        var passheader =
        $('<div class="oxguard_settings"/>')
        .append('<legend class="sectiontitle">' + gt('Password') + '</legend></br>')
        .append('<span> ' + gt('Change Guard Security Password.') + '</span><br/>');
        
        var passwordTable = $('<table/>')
        .append('<tr><td><span>' + gt('Enter current Guard security password') + ': </span></td><td><input type="password" name="oldpass" /><td></tr>')
        .append('<tr><td><span>' + gt('Enter new Guard security password') + ': </span></td><td><input type="password" name="newpass1"/><td></tr>')
        .append('<tr><td><span>' + gt('Verify new Guard security password') + ':</span></td><td><input type="password" name="newpass2"/><td></tr>');
        var errorDiv = $('<div id="grdsettingerror" class="alert alert-info" style="display:none"/>');
        var passButton = $('<button type="button" class="btn btn-primary">' + gt('Change Guard security password') + '</button>');
        passButton.click(passChanged);
        
        return (passheader.append(passwordTable).append(errorDiv).append(passButton));
        
    }
    
    
    function createPasswordReset() {
        var passheader =
            $('<div class="oxguard_settings"/>')
            .append('<legend class="sectiontitle">' + gt('Reset Guard security password') + '</legend></br>')
            .append('<span> ' + gt('Send a temporary Guard security password to my secondary Email address.') + '</span><br/>');
        var passButton = $('<button type="button" class="btn btn-primary">' + gt('Reset Guard security password') + '</button>');
        passButton.click(doReset);
        return (passheader.append(passButton));
        
    }
    
    function createSecondaryChange() {
        updateEmail();
        var emailheader =
            $('<div class="oxguard_settings"/>')
            .append('<legend class="sectiontitle">' + gt('Secondary Email') + '</legend></br>')
            .append('<span> ' + gt('Change Email address used for password reset.') + '</span><br/><br/>')
            .append('<span>' + gt('Current Email address:') + '</span><span id="currentsecondary" style="padding-left:20px;"></span>');
            
            var emailTable = $('<table/>')
            .append('<tr><td><span>' + gt('Enter current Guard security password') + ': </span></td><td><input type="password" name="ogpass" /><td></tr>')
            .append('<tr><td><span>' + gt('Enter new secondary Email address') + ': </span></td><td><input name="newemail"/><td></tr>');
            var errorDiv = $('<div id="newemailerror" class="alert alert-info" style="display:none"/>');
            var emailButton = $('<button type="button" class="btn btn-primary">' + gt('Change Email address') + '</button>');
            emailButton.click(emailChanged);
            
            return (emailheader.append(emailTable).append(errorDiv).append(emailButton));
    }
    
    function updateEmail () {
        $.get(ox.apiRoot + '/oxguard/login?action=secondary&session=' + ox.session + '&userid=' + ox.user_id + '&cid=' + ox.context_id, function (d) {
            d = d.trim();
            if (d.length < 2) {
                $('#currentsecondary').html(gt('None'));
            } else {
                $('#currentsecondary').html(d);
            }
        });
    }
    
    function emailChanged () {
        var email = $('input[name="newemail"]').val();
        if (!validateEmail(email)) {
            $('#newemailerror').html(gt('Invalid email address'));
            $('#newemailerror').focus();
            showError('newemailerror');
        } else {
            var data = {
                    userid : ox.user_id,
                    cid: ox.context_id,
                    email: email,
                    password: $('input[name="ogpass"]').val()
            };
            $.post(ox.apiRoot + '/oxguard/login?action=changesecondary&session=' + ox.session, JSON.stringify(data), function () {
                $('#newemailerror').html(gt('Changed'));
                showError('newemailerror');
                updateEmail();
                $('input[name="ogpass"]').val('');
                $('input[name="newemail"]').val('');
            })
            .fail(function (d) {
                if (d.responseText.trim() === 'Bad password') {
                    $('#newemailerror').html(gt('Bad Password'));
                    showError('newemailerror');
                    $('input[name="ogpass"]').focus();
                }
            });
        }
    }
    
    function showError(id) {
        $('#' + id).show();
        window.setTimeout(function () {
            $('#' + id).hide();
        }, 3000);
    }
    
    function validateEmail(email) {
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }
    
    function doReset() {
        require(['io.ox/core/api/account'], function (api) {
            api.getPrimaryAddress().done(function (data) {// Get primary address as backup
                var primaryEmail = data[1];
                var waitdiv = $('<div class="og_wait" id="keygen"></div');
                waitdiv.append('<i class="fa-key icon-key fa fa-spin icon-spin"/><span>' + gt('Generating key, Please wait') + '</span>');
                $('.window-container-center').append(waitdiv);
                waitdiv.show();
                var param = '&session=' + ox.session + '&userid=' + ox.user_id + '&cid=' + ox.context_id +
                '&default=' + encodeURIComponent(primaryEmail) + '&lang=' + ox.language;
                $.get(ox.apiRoot + '/oxguard/login?action=reset' + param, function (data) {
                    $('.og_wait').remove();
                    require(['io.ox/core/notifications'], function (notify) {
                        if (data.indexOf('primary') >= 0) {
                            notify.yell('success', gt('A new password has been sent to your email address'));
                            return;
                        }
                        if (data.indexOf('ok') >= 0) {
                            notify.yell('success', gt('A new password has been sent to your secondary email address'));
                            return;
                        }
                        if (data.trim() === 'NoRecovery') {
                            notify.yell('error', gt('No password recovery is available'));
                            return;
                        }
                        if (data.indexOf('FailNotify') >= 0) {
                            notify.yell('error', gt('Password reset, but unable to send to your email address'));
                            return;
                        }
                        if (data.indexOf('NoSecondary') >= 0) {
                            notify.yell('error', gt('Unable to find email address to send password reset'));
                            return;
                        }
                            notify.yell('error', gt('Unable to reset your password'));
                    });
                    
                })
                .fail(function () {
                    $('.og_wait').remove();
                    require(['io.ox/core/notifications'], function (notify) {
                        notify.yell('error', gt('Unable to reset your password'));
                    });
                });
            }); 
        });
    }
    
/*    
    function createKeyManager() {
        if (window.oxguarddata.passcode === 'NoPrivate') return ('');// Can't change key if already done
        if (window.oxguarddata.settings.Private !== 'true') return (''); // If not allowed to create own private key settings.
        var keymanager =
            $('<div class="oxguard_settings"/>')
            .append('<legend class="sectiontitle">' + gt('Change Encryption Keys') + '</legend></br>')
            .append('<span>' + gt('Upload your own generated public key, keeping your private key local') + '</span></br>')
            .append('<span>' + gt('For Advanced users only') + '</span></br>');
        var keyButton = $('<button type="button" class="btn btn-primary">' + gt('Start') + '</button>');
        keyButton.click(startNewKeys);
        return (keymanager.append(keyButton));
    }
    
    function startNewKeys() {
        var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter : 'ok'});
        dialog.header($('<h4>').text(gt('New Keys')));
        var warning = $('<p>' + gt('This process will irreversably change the encryption keys on the server.') + '<br/><br/>' + gt('You will be responsible for the private key.  If you lose it, you will lose ALL encrypted data.') +
                gt('You will need to know what public and private keys are, as well as some familiarity with openssl.') + '</p>');
        var warning2 = $('<p style="margin-top:10px;">' + gt('Click OK to Proceed') + '</p>');
        warning.append(warning2);
        dialog.getBody().append(warning);
        dialog
        .addPrimaryButton('ok', gt('OK'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            generateKeys();
        })
        .show();
    }

    function generateKeys() {
        var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter : 'ok'});
        dialog.header($('<h4>').text(gt('New Keys')));
        var stepInstr = $('<p>' + gt('You can start generating keys by using OpenSSL') + '</p><div style="padding:5px; font-style: italic;"><span>openssl genrsa -aes256 -out private.pem 2048</span><br/>' +
                '<br/><span>openssl rsa -in private.pem -out public.pem -pubout -outform PEM</span></div><br/>');
        var nextStep = $('<p>' + gt('When you have generated the keys, click next to proceed') + '</p>');
        dialog.getBody().append(stepInstr).append(nextStep);
        dialog
        .addPrimaryButton('ok', gt('Next'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            getPublic();
        })
        .show();
    }
    
    function getPublic() {
        var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter : 'ok'});
        dialog.header($('<h4>').text(gt('New Keys')));
        var stepInstr = $('<p>' + gt('Please select the public key file below') + '</p>');
        var btn = $('<button class="btn og_getkey">' + gt('Select Key Location') + '</button>');

        var input = $('<input type="file" id="files" name="files[] style="padding:10px;visibility:hidden;position:absolute;top-50px;left:-50px;"/>');
        btn.click(function () {
            input.click();
        });
        input.change(function (evt) {
            var file = evt.target.files[0];
            var reader = new FileReader();

            reader.onload = function (event) {
                var data = event.target.result;
                if (encr.loadPublicKey(data)) {
                    testPrivate();
                    dialog.close();
                } else {
                    alert(gt('Unable to read public key file'));
                }
                
            };
            reader.readAsText(file);
        });
        btn.after(input);
        dialog.getBody().append(stepInstr).append(btn);
        dialog
        .addButton('cancel', gt('Cancel'), 'cancel')
        .show();
    }
    
    function testPrivate() {
        var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter : 'ok'});
        dialog.header($('<h4>').text(gt('Test Private Key')));
        var info = $('<p>' + gt('Please select the file locaiton of your private key.') + '<br/>' + gt('The key will be used locally for testing only.  It will not be sent to the server.') + '</p>');
        var password = $('<label>' + gt('Private Key Password') + '</label><input type="password" id="priv_pass"/></br>');
        info.append(password);
        var btn = $('<button class="btn og_getkey">' + gt('Select Key Location') + '</button>');

        var input = $('<input type="file" id="files" name="files[] style="padding:10px;visibility:hidden;position:absolute;top-50px;left:-50px;"/>');
        btn.click(function () {
            input.click();
        });
        input.change(function (evt) {
            var file = evt.target.files[0];
            var reader = new FileReader();

            reader.onload = function (event) {
                var data = event.target.result;
                var privkey = encr.decodeKey(data, $('#priv_pass').val());
                if (privkey === null) {
                    alert(gt('Unable to open/decode private key'));
                } else {
                    require(['oxguard/crypto/jsencrypt'], function (JS) {
                        var encrypt = new JS.JSEncrypt();
                        encrypt.setPublicKey(window.oxguarddata.publicKey);
                        var encrypted = encrypt.encrypt('testing');
                        var decrypt = new JS.JSEncrypt();
                        decrypt.setPrivateKey(privkey);
                        var uncrypted = decrypt.decrypt(encrypted);
                        if (uncrypted === 'testing') {
                            changeKeys();
                        }
                    });
                    
                }
                dialog.close();
            };
            reader.readAsText(file);

            
        });
        btn.after(input);
        dialog.getBody().append(info.append(btn));
        dialog
        .addButton('cancel', gt('Cancel'), 'cancel');
        dialog.show(function () {
            $('#priv_pass').focus();
        });
    }
    
    function changeKeys() {
        var dialog = new dialogs.CreateDialog({ width: 450, center: true,  enter : 'ok'});
        dialog.header($('<h4>').text(gt('Keys Ready!')));
        var stepInstr = $('<p>' + gt('Please enter your existing/old Encryption password') + '</p>');
        var oldpass = $('<input type="password" id="oldpass"/>');
        stepInstr.append(oldpass);
        var nextStep = $('<p>' + gt('When you are ready, click next to proceed') + '</p>');
        dialog.getBody().append(stepInstr).append(nextStep);
        dialog
        .addPrimaryButton('ok', gt('Next'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            var params = '&session=' + ox.session;
            var dat = {
                    password : $('#oldpass').val(),
                    publicKey : window.oxguarddata.pubkey64,
                    userid : ox.user_id,
                    cid : ox.context_id
                };
            $.post(ox.apiRoot + '/oxguard/keys?action=changepublic' + params, JSON.stringify(dat), function () {
                alert(gt('Success'));
                window.oxguarddata.passcode = 'NoPrivate';
                
                dialog.close();
            })
            .fail(function () {
                alert(gt('Failed'));
            });
        })
        .show(function () {
            $('#oldpass').focus();
        });
        
    }
    
    */
    function passChanged() {

        if ($('input[name="newpass1"]').val() !== $('input[name="newpass2"]').val()) {
            $('input[name="newpass2"]').css('background-color', 'salmon');
            return;
        } else {
            $('input[name="newpass2"]').css('background-color', 'white');
            var userdata = {
                    newpass : $('input[name="newpass1"]').val(),
                    oldpass : $('input[name="oldpass"]').val().trim(),
                    user_id : ox.user_id,
                    sessionID : ox.session,
                    cid : ox.context_id,
                    user : ox.user
                };
            var waitdiv = $('<div class="og_wait" id="keygen"></div');
            waitdiv.append('<i class="fa-key icon-key fa fa-spin icon-spin"/><span>' + gt('Generating key, Please wait') + '</span>');
            $('.window-container-center').append(waitdiv);
            waitdiv.show();
            $.post(ox.apiRoot + '/oxguard/login?action=changepass&session=' + ox.session, JSON.stringify(userdata), function (data) {
                $('.og_wait').remove();
                if (typeof data === 'string') data = $.parseJSON(data);
                if (data.auth === 'Bad password') {
                    $('#grdsettingerror').text(gt('Bad password'));
                }
                if (data.auth === 'Lockout') {
                    $('#grdsettingerror').text(gt('Temporary Lockout'));
                }
                if (data.auth === 'Bad new password') {
                    $('#grdsettingerror').text(gt('New password must be at least %s characters long', data.minlength));
                }
                if (data.auth.length > 20) {
                    $('#grdsettingerror').text(gt('Success'));
                    $('input[name="newpass1"]').val('');
                    $('input[name="newpass2"]').val('');
                    $('input[name="oldpass"]').val('');
                    window.oxguarddata.passcode = null;
                }
                $('#grdsettingerror').show();
                window.setTimeout(function () {
                    $('#grdsettingerror').hide();
                }, 10000);
            
            })
            .fail(function () {
                $('.og_wait').remove();
                $('#grdsettingerror').text(gt('Failed to change password'));
                $('#grdsettingerror').show();
            });
            return;
        }
    }
    
    
    ext.point('oxguard/settings/detail').extend({
        index: 202,
        id: 'oxguardsettings',
        draw: function () {
            if (window.oxguarddata.passcode === 'No Key') {
                require(['oxguard/oxguard_core'], function (oxguard) {
                    oxguard.createKeys();
                });
            }
            var holder = $('<div>').css('max-width', '800px');
            holder.append('<h1>' + gt('Guard Security Settings') + '</h1><br/>');
          //  this.append(holder.append(createPasswordChange())).append(createKeyManager());
            this.append(holder.append(createPasswordChange()).append(createPasswordReset()).append(createSecondaryChange()));
        },

        save: function () {
        }
    });
});
