/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/PGP/register', ['io.ox/core/extensions',
                           'gettext!oxguard/register', 'io.ox/core/extPatterns/links', 'io.ox/mail/view-detail',
                           'css!oxguard/style.css'],
                           function (ext, gt, links, mail) {
    'use strict';
    
    ext.point('io.ox/mail/detail').extend({
        index: 2,
        id: 'ogPGPCheck',
        draw: function (baton) {
            
            console.log(baton.data);
            var mail = baton.data;
            if (mail.results !== undefined) return;
            console.log('PGP Start');
            var attachments = baton.data.attachments;
            for (var i = 0; i < attachments.length; i++) {
             //   var top = (attachments[i].size < 30) ? attachments[i].size : 30;
                if (attachments[i].content_type.toLowerCase().indexOf('pgp-encrypted') > -1) {
                    console.log('PGP MIME FOUND');
                    getPGP(baton);
                }
            }
        }
    });
    
    // Add lock to header
    ext.point('io.ox/mail/detail/header').extend({
        index: 230,
        id: 'ogMailLock',
        draw: function (baton) {
            if (baton.data.PGPresults !== undefined) {
                // Add lock symbol to header
                var lockdiv = $('<div style="float:left; padding-right:5px;" id="lockdiv" class="oxguard_lock" ></div>');
                var lockstack = '<span class="icon-stack" title="' + gt('This Email was sent using PGP encryption. It has been decoded with your private key') + '"><i class="icon-lock icon-large icon-stack-base fa fa-lock -fa-large oxguard_lock" />' +
                    '<i class ="icon-star-half-empty" style="color:black; margin-top:5px;"/></span>';
                lockdiv.append($(lockstack));
                if (baton.data.PGPresults.verified === true) {
                    lockdiv.append('<i class="icon-edit" title="' + gt('This Email was signed by the sender and verified') + '"/>');
                }
                
                $(this).prepend(lockdiv);
             
            }
        }
    });
    
    function getPGP(baton) {
        var params = '&folder=' + baton.data.folder_id +
        '&userid=' + ox.user_id + '&cid=' + ox.context_id + '&password=' +
        '&session=' + ox.session + '&emailid=' + baton.data.id + '&auth=' + window.oxguarddata.passcode;
        console.log(baton.data);
        // Send the request to the oxguard server
        $.get(ox.apiRoot + '/oxguard/pgpmail?action=getmail' + params, function (data) {
            try {
                console.log(data);
                console.log('before');
                console.log(baton.data.attachments);
                baton.data.attachments = data.attachments;
                baton.data.PGPresults = data.results;
                baton.data.content_type = 'multipart/mixed';
                console.log('after');
                console.log(baton.data.attachments);
                $('.mail-detail-decorator').replaceWith(mail.draw(baton));
            } catch (e) {
                
            }
        });
    }
});
