/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.setup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.config.Config;
import com.openexchange.guard.encr.EncrLib;
import com.openexchange.guard.encr.GuardKeys;
import com.openexchange.guard.encr.PgpKeys;


public class MasterPasswordCreator {

	private static Logger logger = LoggerFactory.getLogger(MasterPasswordCreator.class);
	
    public boolean createPasswordFile() {
        Writer writer;
        try {
        	String passfile = Config.getRoot() + "oxguardpass";
        	File file = new File(passfile);
        	if (file.exists()) {
        		logger.info("Password file already exists.  Using existing");
        		return(true);
        	}
            PgpKeys keygen = new PgpKeys();

            EncrLib encr = new EncrLib();
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(Config.getRoot() + "oxguardpass"), "utf-8"));
            String mpass = encr.getsalt();
            String rpass = encr.getsalt();
            writer.write("MC" + mpass + "\r\n");
            writer.write("RC" + rpass + "\r\n");
            Config.mpass = mpass;
            Config.rpass = rpass;
            writer.close();
            try {
            	
            	Runtime.getRuntime().exec("chmod 440 " + passfile);
            	Runtime.getRuntime().exec("chown open-xchange:root " + passfile);
            } catch (Exception ex) {
            	logger.error("Unable to set permissions on password file");

            }
            // Generate the public/private DNS key pair
            try {
                GuardKeys keys = keygen.generateKeys("master", "master@master.com", mpass);
                String publickey = keys.getEncodedPublic();
                String privatekey = keys.getEncodedPrivate();
                Writer privwriter = new BufferedWriter(new OutputStreamWriter(
                    new FileOutputStream(Config.getRoot() + "private_dns_key"),
                    "utf-8"));
                privwriter.write(keys.getSalt() + "\r\n");
                privwriter.write(privatekey);
                privwriter.close();
                Writer pubwriter = new BufferedWriter(new OutputStreamWriter(
                    new FileOutputStream(Config.getRoot() + "public_dns_key"),
                    "utf-8"));
                pubwriter.write(publickey);
                pubwriter.close();
                try {
                	String file2 = Config.getRoot() + "private_dns_key";
                	Runtime.getRuntime().exec("chmod 440 " + file2);
                	Runtime.getRuntime().exec("chown open-xchange:root " + file2);
                } catch (Exception ex) {
                	logger.error("Unable to set permissions on private dns key");
                }
                return(true);
            } catch (Exception e) {
                e.printStackTrace();
                return(false);
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("Failed creating password file", e);
            return(false);
        }
    }
    
    public void setPermissions() {
    	try {
			Runtime.getRuntime().exec("chown -R open-xchange:root " + Config.logDir);
		} catch (IOException e) {
			logger.error("Failed to set log directory permission", e);
		}
    }
}
