/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2014 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.guard.encr;

import java.util.Date;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.guard.config.Config;
import com.openexchange.guard.database.KeyPairGen;


public class RSAGen {
	private static Logger logger = LoggerFactory.getLogger(RSAGen.class);
    /**
     * Generate RSA/PGP keys for user. Use the RSA key cache
     * 
     * @param name Name of user
     * @param email Email address
     * @param password Password to protect keys
     * @return
     */
    public GuardKeys generateKeyPair(String name, String email, String password) {
        return (generateKeyPair(name, email, password, false));
    }

    /**
     * Generate RSA/PGP keys for user.
     * 
     * @param name Name of user
     * @param email Email address
     * @param password Password to protect keys
     * @param failover If no keys in cache, then generate real-time
     * @return
     */
    public GuardKeys generateKeyPair(String name, String email, String password, boolean failover) {
        try {
            PgpKeys pgpk = new PgpKeys();
            if (!Config.rsa_cache) {// If we are not using the RSA_Cache, just return real-time created key
                return (pgpk.generateKeys(name, email, password));
            }
            // Load pre-generated key pairs
            AsymmetricCipherKeyPair mst = KeyPairGen.getKeyPair();
            if (mst == null)
                return (null);
            AsymmetricCipherKeyPair enc = KeyPairGen.getKeyPair();
            if (enc == null)
                return (null);

            // Create PGPKey Pairs
            PGPKeyPair rsa_master = new BcPGPKeyPair(PGPPublicKey.RSA_GENERAL, mst, new Date());
            // SubKey
            PGPKeyPair rsa_encrypt = new BcPGPKeyPair(PGPPublicKey.RSA_GENERAL, enc, new Date());
            // return generated oxGuardKeys
            return (pgpk.generateKeys(name, email, password, rsa_master, rsa_encrypt));

        } catch (Exception ex) {
        	logger.error("Problem retrieving pregenerated keys.  Change in password file???", ex);
            return (null);
        }
    }

}
