/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.DescribeObjectsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DescribeObjectsRequestMarshaller
implements Marshaller<Request<DescribeObjectsRequest>, DescribeObjectsRequest> {
    @Override
    public Request<DescribeObjectsRequest> marshall(DescribeObjectsRequest describeObjectsRequest) {
        if (describeObjectsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeObjectsRequest> request = new DefaultRequest<DescribeObjectsRequest>(describeObjectsRequest, "DataPipeline");
        String target = "DataPipeline.DescribeObjects";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag objectIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (describeObjectsRequest.getPipelineId() != null) {
                jsonWriter.key("pipelineId").value(describeObjectsRequest.getPipelineId());
            }
            if (!((objectIdsList = (ListWithAutoConstructFlag)describeObjectsRequest.getObjectIds()) == null || objectIdsList.isAutoConstruct() && objectIdsList.isEmpty())) {
                jsonWriter.key("objectIds");
                jsonWriter.array();
                for (String objectIdsListValue : objectIdsList) {
                    if (objectIdsListValue == null) continue;
                    jsonWriter.value(objectIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (describeObjectsRequest.isEvaluateExpressions() != null) {
                jsonWriter.key("evaluateExpressions").value(describeObjectsRequest.isEvaluateExpressions());
            }
            if (describeObjectsRequest.getMarker() != null) {
                jsonWriter.key("marker").value(describeObjectsRequest.getMarker());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

