/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import java.util.EnumMap;
import java.util.Map;
import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public final class RequestClientOptions {
    private final Map<Marker, String> markers = new EnumMap<Marker, String>(Marker.class);

    @Deprecated
    public String getClientMarker() {
        return this.getClientMarker(Marker.USER_AGENT);
    }

    public String getClientMarker(Marker marker) {
        return this.markers.get((Object)marker);
    }

    public void putClientMarker(Marker marker, String value) {
        this.markers.put(marker, value);
    }

    @Deprecated
    public void addClientMarker(String clientMarker) {
        this.appendUserAgent(clientMarker);
    }

    public void appendUserAgent(String userAgent) {
        String marker = this.markers.get((Object)Marker.USER_AGENT);
        if (marker == null) {
            marker = "";
        }
        marker = this.createUserAgentMarkerString(marker, userAgent);
        this.putClientMarker(Marker.USER_AGENT, marker);
    }

    private String createUserAgentMarkerString(String marker, String userAgent) {
        return marker.contains(userAgent) ? marker : marker + " " + userAgent;
    }

    public static enum Marker {
        USER_AGENT;

    }
}

