/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.functor;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.functor.Executor;
import org.apache.commons.lang.functor.ExecutorException;
import org.apache.commons.lang.functor.Factory;
import org.apache.commons.lang.functor.FactoryException;
import org.apache.commons.lang.functor.FactoryUtils;
import org.apache.commons.lang.functor.Predicate;
import org.apache.commons.lang.functor.PredicateException;
import org.apache.commons.lang.functor.PredicateUtils;
import org.apache.commons.lang.functor.Transformer;
import org.apache.commons.lang.functor.TransformerException;

public class TransformerUtils {
    private static final Transformer EXCEPTION_TRANSFORMER = new ExceptionTransformer();
    private static final Transformer NULL_TRANSFORMER = new ConstantTransformer(null);
    private static final Transformer NOP_TRANSFORMER = new NOPTransformer();
    private static final Transformer CLONE_TRANSFORMER = new CloneTransformer();
    private static final Transformer INSTANTIATE_TRANSFORMER = new InstantiateTransformer(null, null);

    protected TransformerUtils() {
    }

    public static Transformer exceptionTransformer() {
        return EXCEPTION_TRANSFORMER;
    }

    public static Transformer nullTransformer() {
        return NULL_TRANSFORMER;
    }

    public static Transformer nopTransformer() {
        return NOP_TRANSFORMER;
    }

    public static Transformer cloneTransformer() {
        return CLONE_TRANSFORMER;
    }

    public static Transformer constantTransformer(Object constantToReturn) {
        return new ConstantTransformer(constantToReturn);
    }

    public static Transformer asTransformer(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("The executor must not be null");
        }
        return new ExecutorTransformer(executor);
    }

    public static Transformer asTransformer(Predicate predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        return new PredicateTransformer(predicate);
    }

    public static Transformer asTransformer(Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("The factory must not be null");
        }
        return new FactoryTransformer(factory);
    }

    public static Transformer chainedTransformer(Transformer transformer1, Transformer transformer2) {
        Transformer[] trs = new Transformer[]{transformer1, transformer2};
        TransformerUtils.validate(trs);
        return new ChainedTransformer(trs);
    }

    public static Transformer chainedTransformer(Transformer[] transformers) {
        Transformer[] trs = TransformerUtils.copy(transformers);
        TransformerUtils.validate(trs);
        return new ChainedTransformer(trs);
    }

    public static Transformer chainedTransformer(Collection transformers) {
        Transformer[] trs = null;
        if (transformers == null) {
            throw new IllegalArgumentException("The transformer collection must not be null");
        }
        trs = new Transformer[transformers.size()];
        int i = 0;
        Iterator it = transformers.iterator();
        while (it.hasNext()) {
            trs[i++] = (Transformer)it.next();
        }
        TransformerUtils.validate(trs);
        return new ChainedTransformer(trs);
    }

    public static Transformer switchTransformer(Predicate predicate, Transformer trueTransformer, Transformer falseTransformer) {
        return TransformerUtils.switchTransformerInternal(new Predicate[]{predicate}, new Transformer[]{trueTransformer}, falseTransformer);
    }

    public static Transformer switchTransformer(Predicate[] predicates, Transformer[] transformers) {
        return TransformerUtils.switchTransformerInternal(TransformerUtils.copy(predicates), TransformerUtils.copy(transformers), null);
    }

    public static Transformer switchTransformer(Predicate[] predicates, Transformer[] transformers, Transformer defaultTransformer) {
        return TransformerUtils.switchTransformerInternal(TransformerUtils.copy(predicates), TransformerUtils.copy(transformers), defaultTransformer);
    }

    public static Transformer switchTransformer(Map predicatesAndTransformers) {
        Transformer[] trs = null;
        Predicate[] preds = null;
        if (predicatesAndTransformers == null) {
            throw new IllegalArgumentException("The predicate and transformer map must not be null");
        }
        Transformer def = (Transformer)predicatesAndTransformers.remove(null);
        int size = predicatesAndTransformers.size();
        trs = new Transformer[size];
        preds = new Predicate[size];
        int i = 0;
        Iterator it = predicatesAndTransformers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            preds[i] = (Predicate)entry.getKey();
            trs[i] = (Transformer)entry.getValue();
            ++i;
        }
        return TransformerUtils.switchTransformerInternal(preds, trs, def);
    }

    private static Transformer switchTransformerInternal(Predicate[] predicates, Transformer[] transformers, Transformer defaultTransformer) {
        TransformerUtils.validate(predicates);
        TransformerUtils.validate(transformers);
        if (predicates.length != transformers.length) {
            throw new IllegalArgumentException("The predicate and transformer arrays must be the same size");
        }
        if (defaultTransformer == null) {
            defaultTransformer = TransformerUtils.nullTransformer();
        }
        return new SwitchTransformer(predicates, transformers, defaultTransformer);
    }

    public static Transformer switchMapTransformer(Map objectsAndTransformers) {
        Transformer[] trs = null;
        Predicate[] preds = null;
        if (objectsAndTransformers == null) {
            throw new IllegalArgumentException("The obejct and transformer map must not be null");
        }
        Transformer def = (Transformer)objectsAndTransformers.remove(null);
        int size = objectsAndTransformers.size();
        trs = new Transformer[size];
        preds = new Predicate[size];
        int i = 0;
        Iterator it = objectsAndTransformers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            preds[i] = PredicateUtils.equalPredicate(entry.getKey());
            trs[i] = (Transformer)entry.getValue();
            ++i;
        }
        return TransformerUtils.switchTransformer(preds, trs, def);
    }

    public static Transformer instantiateTransformer() {
        return INSTANTIATE_TRANSFORMER;
    }

    public static Transformer instantiateTransformer(Class[] paramTypes, Object[] args) {
        return new InstantiateTransformer(paramTypes, args);
    }

    public static Transformer mapTransformer(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("The map must not be null");
        }
        return new MapTransformer(map);
    }

    public static Transformer invokerTransformer(String methodName) {
        return new InvokerTransformer(methodName, null, null);
    }

    public static Transformer invokerTransformer(String methodName, Class[] paramTypes, Object[] args) {
        return new InvokerTransformer(methodName, paramTypes, args);
    }

    private static Predicate[] copy(Predicate[] predicates) {
        if (predicates == null) {
            return null;
        }
        return (Predicate[])predicates.clone();
    }

    private static void validate(Predicate[] predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate array must not be null");
        }
        if (predicates.length < 1) {
            throw new IllegalArgumentException("At least 1 predicate must be specified in the predicate array, size was " + predicates.length);
        }
        int i = 0;
        while (i < predicates.length) {
            if (predicates[i] == null) {
                throw new IllegalArgumentException("The predicate array must not contain a null predicate, index " + i + " was null");
            }
            ++i;
        }
    }

    private static Transformer[] copy(Transformer[] transformers) {
        if (transformers == null) {
            return null;
        }
        return (Transformer[])transformers.clone();
    }

    private static void validate(Transformer[] transformers) {
        if (transformers == null) {
            throw new IllegalArgumentException("The transformer array must not be null");
        }
        if (transformers.length < 1) {
            throw new IllegalArgumentException("At least 1 transformer must be specified in the transformer array, size was " + transformers.length);
        }
        int i = 0;
        while (i < transformers.length) {
            if (transformers[i] == null) {
                throw new IllegalArgumentException("The transformer array must not contain a null transformer, index " + i + " was null");
            }
            ++i;
        }
    }

    private static class InvokerTransformer
    implements Transformer,
    Serializable {
        private final String iMethodName;
        private final Class[] iParamTypes;
        private final Object[] iArgs;

        public InvokerTransformer(String methodName, Class[] paramTypes, Object[] args) {
            if (methodName == null) {
                throw new IllegalArgumentException("InvokerTransformer: The method to invoke must not be null");
            }
            if (paramTypes == null && args != null || paramTypes != null && args == null || paramTypes != null && args != null && paramTypes.length != args.length) {
                throw new IllegalArgumentException("InvokerTransformer: The parameter types must match the arguments");
            }
            this.iMethodName = methodName;
            if (paramTypes == null && args == null) {
                this.iParamTypes = null;
                this.iArgs = null;
            } else {
                this.iParamTypes = (Class[])paramTypes.clone();
                this.iArgs = (Object[])args.clone();
            }
        }

        public Object transform(Object input) {
            if (input == null) {
                return null;
            }
            try {
                Class<?> cls = input.getClass();
                Method method = cls.getMethod(this.iMethodName, this.iParamTypes);
                return method.invoke(input, this.iArgs);
            }
            catch (NoSuchMethodException ex) {
                throw new TransformerException("InvokerTransformer: The method '" + this.iMethodName + "' on '" + input.getClass() + "' does not exist");
            }
            catch (IllegalAccessException ex) {
                throw new TransformerException("InvokerTransformer: The method '" + this.iMethodName + "' on '" + input.getClass() + "' cannot be accessed");
            }
            catch (InvocationTargetException ex) {
                throw new TransformerException("InvokerTransformer: The method '" + this.iMethodName + "' on '" + input.getClass() + "' threw an exception", ex);
            }
        }
    }

    private static class MapTransformer
    implements Transformer,
    Serializable {
        private final Map iMap;

        private MapTransformer(Map map) {
            this.iMap = map;
        }

        public Object transform(Object input) {
            return this.iMap.get(input);
        }
    }

    private static class InstantiateTransformer
    implements Transformer,
    Serializable {
        private final Class[] iParamTypes;
        private final Object[] iArgs;

        private InstantiateTransformer(Class[] paramTypes, Object[] args) {
            if (paramTypes == null && args != null || paramTypes != null && args == null || paramTypes != null && args != null && paramTypes.length != args.length) {
                throw new IllegalArgumentException("InstantiateTransformer: The parameter types must match the arguments");
            }
            if (paramTypes == null && args == null) {
                this.iParamTypes = null;
                this.iArgs = null;
            } else {
                this.iParamTypes = (Class[])paramTypes.clone();
                this.iArgs = (Object[])args.clone();
            }
        }

        public Object transform(Object input) {
            try {
                if (!(input instanceof Class)) {
                    throw new TransformerException("InstantiateTransformer: Input object was not an instanceof Class, it was a " + (input == null ? "null object" : input.getClass().getName()));
                }
                return FactoryUtils.reflectionFactory((Class)input, this.iParamTypes, this.iArgs).create();
            }
            catch (IllegalArgumentException ex) {
                throw new TransformerException("InstantiateTransformer", ex);
            }
            catch (FactoryException ex) {
                throw new TransformerException("InstantiateTransformer", ex);
            }
        }
    }

    private static class SwitchTransformer
    implements Transformer,
    Serializable {
        private final Predicate[] iPredicates;
        private final Transformer[] iTransformers;
        private final Transformer iDefault;

        private SwitchTransformer(Predicate[] predicates, Transformer[] transformers, Transformer defaultTransformer) {
            this.iPredicates = predicates;
            this.iTransformers = transformers;
            this.iDefault = defaultTransformer;
        }

        public Object transform(Object input) {
            int i = 0;
            while (i < this.iPredicates.length) {
                if (this.iPredicates[i].evaluate(input)) {
                    return this.iTransformers[i].transform(input);
                }
                ++i;
            }
            return this.iDefault.transform(input);
        }
    }

    private static class ChainedTransformer
    implements Transformer,
    Serializable {
        private final Transformer[] iTransformers;

        private ChainedTransformer(Transformer[] transformers) {
            this.iTransformers = transformers;
        }

        public Object transform(Object object) {
            int i = 0;
            while (i < this.iTransformers.length) {
                object = this.iTransformers[i].transform(object);
                ++i;
            }
            return object;
        }
    }

    private static class FactoryTransformer
    implements Transformer,
    Serializable {
        private final Factory iFactory;

        private FactoryTransformer(Factory factory) {
            this.iFactory = factory;
        }

        public Object transform(Object input) {
            try {
                return this.iFactory.create();
            }
            catch (FactoryException ex) {
                throw new TransformerException("FactoryTransformer: " + ex.getMessage(), ex);
            }
        }
    }

    private static class PredicateTransformer
    implements Transformer,
    Serializable {
        private final Predicate iPredicate;

        private PredicateTransformer(Predicate predicate) {
            this.iPredicate = predicate;
        }

        public Object transform(Object input) {
            try {
                return new Boolean(this.iPredicate.evaluate(input));
            }
            catch (PredicateException ex) {
                throw new TransformerException("PredicateTransformer: " + ex.getMessage(), ex);
            }
        }
    }

    private static class ExecutorTransformer
    implements Transformer,
    Serializable {
        private final Executor iExecutor;

        private ExecutorTransformer(Executor executor) {
            this.iExecutor = executor;
        }

        public Object transform(Object input) {
            try {
                this.iExecutor.execute(input);
                return input;
            }
            catch (ExecutorException ex) {
                throw new TransformerException("ExecutorTransformer: " + ex.getMessage(), ex);
            }
        }
    }

    private static class ConstantTransformer
    implements Transformer,
    Serializable {
        private final Object iConstant;

        private ConstantTransformer(Object constant) {
            this.iConstant = constant;
        }

        public Object transform(Object input) {
            return this.iConstant;
        }
    }

    private static class CloneTransformer
    implements Transformer,
    Serializable {
        private CloneTransformer() {
        }

        public Object transform(Object input) {
            if (input == null) {
                return null;
            }
            try {
                return FactoryUtils.prototypeFactory(input).create();
            }
            catch (IllegalArgumentException ex) {
                throw new TransformerException("CloneTransformer", ex);
            }
            catch (FactoryException ex) {
                throw new TransformerException("CloneTransformer", ex);
            }
        }
    }

    private static class NOPTransformer
    implements Transformer,
    Serializable {
        private NOPTransformer() {
        }

        public Object transform(Object input) {
            return input;
        }
    }

    private static class ExceptionTransformer
    implements Transformer,
    Serializable {
        private ExceptionTransformer() {
        }

        public Object transform(Object input) {
            throw new TransformerException("ExceptionTransformer invoked");
        }
    }
}

