/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.functor;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.functor.Executor;
import org.apache.commons.lang.functor.ExecutorException;
import org.apache.commons.lang.functor.Predicate;
import org.apache.commons.lang.functor.PredicateUtils;
import org.apache.commons.lang.functor.Transformer;
import org.apache.commons.lang.functor.TransformerException;
import org.apache.commons.lang.functor.TransformerUtils;

public class ExecutorUtils {
    private static final Executor EXCEPTION_EXECUTOR = new ExceptionExecutor();
    private static final Executor NOP_EXECUTOR = new NOPExecutor();

    protected ExecutorUtils() {
    }

    public static Executor exceptionExecutor() {
        return EXCEPTION_EXECUTOR;
    }

    public static Executor nopExecutor() {
        return NOP_EXECUTOR;
    }

    public static Executor asExecutor(Transformer transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("The transformer must not be null");
        }
        return new TransformerExecutor(transformer);
    }

    public static Executor forExecutor(int count, Executor executor) {
        if (count < 0) {
            throw new IllegalArgumentException("The loop count must not be less than zero, it was " + count);
        }
        if (executor == null) {
            throw new IllegalArgumentException("The executor must not be null");
        }
        return new ForExecutor(count, executor);
    }

    public static Executor whileExecutor(Predicate predicate, Executor executor) {
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("The executor must not be null");
        }
        return new WhileExecutor(predicate, executor, false);
    }

    public static Executor doWhileExecutor(Executor executor, Predicate predicate) {
        if (executor == null) {
            throw new IllegalArgumentException("The executor must not be null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        return new WhileExecutor(predicate, executor, true);
    }

    public static Executor invokerExecutor(String methodName) {
        return ExecutorUtils.asExecutor(TransformerUtils.invokerTransformer(methodName, null, null));
    }

    public static Executor invokerExecutor(String methodName, Class[] paramTypes, Object[] args) {
        return ExecutorUtils.asExecutor(TransformerUtils.invokerTransformer(methodName, paramTypes, args));
    }

    public static Executor chainedExecutor(Executor executor1, Executor executor2) {
        Executor[] executors = new Executor[]{executor1, executor2};
        ExecutorUtils.validate(executors);
        return new ChainedExecutor(executors);
    }

    public static Executor chainedExecutor(Executor[] executors) {
        executors = ExecutorUtils.copy(executors);
        ExecutorUtils.validate(executors);
        return new ChainedExecutor(executors);
    }

    public static Executor chainedExecutor(Collection executors) {
        if (executors == null) {
            throw new IllegalArgumentException("The executor collection must not be null");
        }
        Executor[] cmds = new Executor[executors.size()];
        int i = 0;
        Iterator it = executors.iterator();
        while (it.hasNext()) {
            cmds[i++] = (Executor)it.next();
        }
        ExecutorUtils.validate(cmds);
        return new ChainedExecutor(cmds);
    }

    public static Executor switchExecutor(Predicate predicate, Executor trueExecutor, Executor falseExecutor) {
        return ExecutorUtils.switchExecutorInternal(new Predicate[]{predicate}, new Executor[]{trueExecutor}, falseExecutor);
    }

    public static Executor switchExecutor(Predicate[] predicates, Executor[] executors) {
        return ExecutorUtils.switchExecutorInternal(ExecutorUtils.copy(predicates), ExecutorUtils.copy(executors), null);
    }

    public static Executor switchExecutor(Predicate[] predicates, Executor[] executors, Executor defaultExecutor) {
        return ExecutorUtils.switchExecutorInternal(ExecutorUtils.copy(predicates), ExecutorUtils.copy(executors), defaultExecutor);
    }

    public static Executor switchExecutor(Map predicatesAndExecutors) {
        Executor[] trs = null;
        Predicate[] preds = null;
        if (predicatesAndExecutors == null) {
            throw new IllegalArgumentException("The predicate and executor map must not be null");
        }
        Executor def = (Executor)predicatesAndExecutors.remove(null);
        int size = predicatesAndExecutors.size();
        trs = new Executor[size];
        preds = new Predicate[size];
        int i = 0;
        Iterator it = predicatesAndExecutors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            preds[i] = (Predicate)entry.getKey();
            trs[i] = (Executor)entry.getValue();
            ++i;
        }
        return ExecutorUtils.switchExecutorInternal(preds, trs, def);
    }

    private static Executor switchExecutorInternal(Predicate[] predicates, Executor[] executors, Executor defaultExecutor) {
        ExecutorUtils.validate(predicates);
        ExecutorUtils.validate(executors);
        if (predicates.length != executors.length) {
            throw new IllegalArgumentException("The predicate and executor arrays must be the same size");
        }
        if (defaultExecutor == null) {
            defaultExecutor = ExecutorUtils.nopExecutor();
        }
        return new SwitchExecutor(predicates, executors, defaultExecutor);
    }

    public static Executor switchMapExecutor(Map objectsAndExecutors) {
        Executor[] trs = null;
        Predicate[] preds = null;
        if (objectsAndExecutors == null) {
            throw new IllegalArgumentException("The obejct and executor map must not be null");
        }
        Executor def = (Executor)objectsAndExecutors.remove(null);
        int size = objectsAndExecutors.size();
        trs = new Executor[size];
        preds = new Predicate[size];
        int i = 0;
        Iterator it = objectsAndExecutors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            preds[i] = PredicateUtils.equalPredicate(entry.getKey());
            trs[i] = (Executor)entry.getValue();
            ++i;
        }
        return ExecutorUtils.switchExecutor(preds, trs, def);
    }

    private static Predicate[] copy(Predicate[] predicates) {
        if (predicates == null) {
            return null;
        }
        return (Predicate[])predicates.clone();
    }

    private static void validate(Predicate[] predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate array must not be null");
        }
        if (predicates.length < 1) {
            throw new IllegalArgumentException("At least 1 predicate must be specified in the predicate array, size was " + predicates.length);
        }
        int i = 0;
        while (i < predicates.length) {
            if (predicates[i] == null) {
                throw new IllegalArgumentException("The predicate array must not contain a null predicate, index " + i + " was null");
            }
            ++i;
        }
    }

    private static Executor[] copy(Executor[] executors) {
        if (executors == null) {
            return null;
        }
        return (Executor[])executors.clone();
    }

    private static void validate(Executor[] executors) {
        if (executors == null) {
            throw new IllegalArgumentException("The executor array must not be null");
        }
        if (executors.length < 1) {
            throw new IllegalArgumentException("At least 1 executor must be specified in the executor array, size was " + executors.length);
        }
        int i = 0;
        while (i < executors.length) {
            if (executors[i] == null) {
                throw new IllegalArgumentException("The executor array must not contain a null executor, index " + i + " was null");
            }
            ++i;
        }
    }

    private static class WhileExecutor
    implements Executor,
    Serializable {
        private final Predicate iPredicate;
        private final Executor iExecutor;
        private final boolean iDoLoop;

        private WhileExecutor(Predicate predicate, Executor executor, boolean doLoop) {
            this.iPredicate = predicate;
            this.iExecutor = executor;
            this.iDoLoop = doLoop;
        }

        public void execute(Object input) {
            if (this.iDoLoop) {
                this.iExecutor.execute(input);
            }
            while (this.iPredicate.evaluate(input)) {
                this.iExecutor.execute(input);
            }
        }
    }

    private static class ForExecutor
    implements Executor,
    Serializable {
        private final int iCount;
        private final Executor iExecutor;

        private ForExecutor(int count, Executor executor) {
            this.iCount = count;
            this.iExecutor = executor;
        }

        public void execute(Object input) {
            int i = 0;
            while (i < this.iCount) {
                this.iExecutor.execute(input);
                ++i;
            }
        }
    }

    private static class SwitchExecutor
    implements Executor,
    Serializable {
        private final Predicate[] iPredicates;
        private final Executor[] iExecutors;
        private final Executor iDefault;

        private SwitchExecutor(Predicate[] predicates, Executor[] executors, Executor defaultExecutor) {
            this.iPredicates = predicates;
            this.iExecutors = executors;
            this.iDefault = defaultExecutor;
        }

        public void execute(Object input) {
            int i = 0;
            while (i < this.iPredicates.length) {
                if (this.iPredicates[i].evaluate(input)) {
                    this.iExecutors[i].execute(input);
                    return;
                }
                ++i;
            }
            this.iDefault.execute(input);
        }
    }

    private static class ChainedExecutor
    implements Executor,
    Serializable {
        private final Executor[] iExecutors;

        private ChainedExecutor(Executor[] executors) {
            this.iExecutors = executors;
        }

        public void execute(Object input) {
            int i = 0;
            while (i < this.iExecutors.length) {
                this.iExecutors[i].execute(input);
                ++i;
            }
        }
    }

    private static class TransformerExecutor
    implements Executor,
    Serializable {
        private final Transformer iTransformer;

        private TransformerExecutor(Transformer transformer) {
            this.iTransformer = transformer;
        }

        public void execute(Object input) {
            try {
                this.iTransformer.transform(input);
            }
            catch (TransformerException ex) {
                throw new ExecutorException("TransformerExecutor: " + ex.getMessage(), ex);
            }
        }
    }

    private static class NOPExecutor
    implements Executor,
    Serializable {
        private NOPExecutor() {
        }

        public void execute(Object input) {
        }
    }

    private static class ExceptionExecutor
    implements Executor,
    Serializable {
        private ExceptionExecutor() {
        }

        public void execute(Object input) {
            throw new ExecutorException("ExceptionExecutor invoked");
        }
    }
}

