/*
 *
 *  Copyright (C) 2012 Open-Xchange, Inc. All rights reserved.
 *
 *  This program is proprietary software and licensed to you under Open-Xchange
 *  Inc's Software License Agreement.
 *
 *  In some countries OX, OX Open-Xchange, open-xchange and OXtender as well as
 *  the corresponding Logos OX Open-Xchange and OX are registered trademarks of
 *  the Open-Xchange, Inc. group of companies.
 *
 */

package com.openexchange.documentconverter;

public enum Feature {

    // - Enums -----------------------------------------------------------------

    DOCUMENTCONVERTER(0x00000001),

    // you may pass a source mime type String
    // parameter to the IManager.hasFeature method,
    // in order to detect if the SharePoint service
    // is supported for this kind of source document
    SHAREPOINT_PDFCONVERSION(0x00000002),

    REMOTE_DOCUMENTCONVERTER(0x00000004);

    // - Enum implementation ---------------------------------------------------

    /**
     *
     */
    Feature(int id) {
        this.m_id = id;
    }

    /**
     * @return
     */
    public int id() {
        return m_id;
    }

    /**
     * @param feature The feature to check for existence within the ORed id
     * @param featureIds ORed value of feature ids
     * @return true, if the ORed feature id contains an id for the requested feature
     */
    public static boolean isFeatureSupported(int featuresId, Feature feature) {
        return ((featuresId & feature.id()) == feature.id());
    }

    /**
     * @param featureX var arg list of Feature arguments to calculate the ORed feature id from
     * @return The ORed feature id of all given Feature arguments
     */
    public static int getFeaturesId(Feature ... featureX) {
        int featuresId = 0;

        for (int i = 0; i < featureX.length; ++i) {
            featuresId |= featureX[i].id();
        }

        return featuresId;
    }

    // - Members ---------------------------------------------------------------

    private final int m_id;
}
