/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.protocols.urp.Cache;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.Enum;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IFieldDescription;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XInterface;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

final class Marshal {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final DataOutput output = new DataOutputStream(this.buffer);
    private final IBridge bridge;
    private final Cache objectIdCache;
    private final Cache threadIdCache;
    private final Cache typeCache;

    public Marshal(IBridge iBridge, short s) {
        this.bridge = iBridge;
        this.objectIdCache = new Cache(s);
        this.threadIdCache = new Cache(s);
        this.typeCache = new Cache(s);
    }

    public void write8Bit(int n) {
        try {
            this.output.writeByte(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public void write16Bit(int n) {
        try {
            this.output.writeShort(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public void writeObjectId(String string) {
        if (string == null) {
            this.writeStringValue(null);
            this.write16Bit(65535);
        } else {
            boolean[] blArray = new boolean[1];
            int n = this.objectIdCache.add(blArray, string);
            this.writeStringValue(blArray[0] ? null : string);
            this.write16Bit(n);
        }
    }

    public void writeInterface(XInterface xInterface, Type type) {
        this.writeObjectId((String)this.bridge.mapInterfaceTo(xInterface, type));
    }

    public void writeThreadId(ThreadId threadId) {
        byte[] byArray = threadId.getBytes();
        boolean[] blArray = new boolean[1];
        int n = this.threadIdCache.add(blArray, byArray);
        if (blArray[0]) {
            this.writeCompressedNumber(0);
        } else {
            this.writeCompressedNumber(byArray.length);
            this.writeBytes(byArray);
        }
        this.write16Bit(n);
    }

    public void writeType(TypeDescription typeDescription) {
        TypeClass typeClass = typeDescription.getTypeClass();
        if (TypeDescription.isTypeClassSimple(typeClass)) {
            this.write8Bit(typeClass.getValue());
        } else {
            boolean[] blArray = new boolean[1];
            int n = this.typeCache.add(blArray, typeDescription.getTypeName());
            this.write8Bit(typeClass.getValue() | (blArray[0] ? 0 : 128));
            this.write16Bit(n);
            if (!blArray[0]) {
                this.writeStringValue(typeDescription.getTypeName());
            }
        }
    }

    public void writeValue(TypeDescription typeDescription, Object object) {
        switch (typeDescription.getTypeClass().getValue()) {
            case 0: {
                break;
            }
            case 2: {
                this.writeBooleanValue((Boolean)object);
                break;
            }
            case 3: {
                this.writeByteValue((Byte)object);
                break;
            }
            case 4: 
            case 5: {
                this.writeShortValue((Short)object);
                break;
            }
            case 6: 
            case 7: {
                this.writeLongValue((Integer)object);
                break;
            }
            case 8: 
            case 9: {
                this.writeHyperValue((Long)object);
                break;
            }
            case 10: {
                this.writeFloatValue((Float)object);
                break;
            }
            case 11: {
                this.writeDoubleValue((Double)object);
                break;
            }
            case 1: {
                this.writeCharValue((Character)object);
                break;
            }
            case 12: {
                this.writeStringValue((String)object);
                break;
            }
            case 13: {
                this.writeTypeValue((Type)object);
                break;
            }
            case 14: {
                this.writeAnyValue(object);
                break;
            }
            case 20: {
                this.writeSequenceValue(typeDescription, object);
                break;
            }
            case 15: {
                this.writeEnumValue(typeDescription, (Enum)object);
                break;
            }
            case 17: {
                this.writeStructValue(typeDescription, object);
                break;
            }
            case 19: {
                this.writeExceptionValue(typeDescription, (Exception)object);
                break;
            }
            case 22: {
                this.writeInterfaceValue(typeDescription, (XInterface)object);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad type descriptor " + typeDescription);
            }
        }
    }

    public byte[] reset() {
        byte[] byArray = this.buffer.toByteArray();
        this.buffer.reset();
        return byArray;
    }

    private void writeBooleanValue(Boolean bl) {
        try {
            this.output.writeBoolean(bl != null && bl != false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void writeByteValue(Byte by) {
        this.write8Bit(by == null ? (byte)0 : by);
    }

    private void writeShortValue(Short s) {
        this.write16Bit(s == null ? (short)0 : s);
    }

    private void writeLongValue(Integer n) {
        this.write32Bit(n == null ? 0 : n);
    }

    private void writeHyperValue(Long l) {
        try {
            this.output.writeLong(l == null ? 0L : l);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void writeFloatValue(Float f) {
        try {
            this.output.writeFloat(f == null ? 0.0f : f.floatValue());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void writeDoubleValue(Double d) {
        try {
            this.output.writeDouble(d == null ? 0.0 : d);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void writeCharValue(Character c) {
        try {
            this.output.writeChar(c == null ? (char)'\u0000' : c.charValue());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void writeStringValue(String string) {
        if (string == null) {
            this.writeCompressedNumber(0);
        } else {
            byte[] byArray;
            try {
                byArray = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.toString());
            }
            this.writeCompressedNumber(byArray.length);
            this.writeBytes(byArray);
        }
    }

    private void writeTypeValue(Type type) {
        try {
            this.writeType(TypeDescription.getTypeDescription(type == null ? Type.VOID : type));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.toString());
        }
    }

    private void writeAnyValue(Object object) {
        TypeDescription typeDescription;
        if (object == null || object instanceof XInterface) {
            typeDescription = TypeDescription.getTypeDescription(XInterface.class);
        } else if (object instanceof Any) {
            Any any = (Any)object;
            try {
                typeDescription = TypeDescription.getTypeDescription(any.getType());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.toString());
            }
            object = any.getObject();
        } else {
            if (object.getClass() == Object.class) {
                throw new IllegalArgumentException("Object instance does not represent UNO value");
            }
            typeDescription = TypeDescription.getTypeDescription(object.getClass());
        }
        this.writeType(typeDescription);
        this.writeValue(typeDescription, object);
    }

    private void writeSequenceValue(TypeDescription typeDescription, Object object) {
        if (object == null) {
            this.writeCompressedNumber(0);
        } else {
            TypeDescription typeDescription2 = (TypeDescription)typeDescription.getComponentType();
            if (typeDescription2.getTypeClass() == TypeClass.BYTE) {
                byte[] byArray = (byte[])object;
                this.writeCompressedNumber(byArray.length);
                this.writeBytes(byArray);
            } else {
                int n = Array.getLength(object);
                this.writeCompressedNumber(n);
                for (int i = 0; i < n; ++i) {
                    this.writeValue(typeDescription2, Array.get(object, i));
                }
            }
        }
    }

    private void writeEnumValue(TypeDescription typeDescription, Enum enum_) {
        int n;
        if (enum_ == null) {
            try {
                n = ((Enum)typeDescription.getZClass().getMethod("getDefault", null).invoke(null, (Object[])null)).getValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException.toString());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.toString());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException.toString());
            }
        } else {
            n = enum_.getValue();
        }
        this.write32Bit(n);
    }

    private void writeStructValue(TypeDescription typeDescription, Object object) {
        IFieldDescription[] iFieldDescriptionArray = typeDescription.getFieldDescriptions();
        for (int i = 0; i < iFieldDescriptionArray.length; ++i) {
            try {
                this.writeValue((TypeDescription)iFieldDescriptionArray[i].getTypeDescription(), object == null ? null : iFieldDescriptionArray[i].getField().get(object));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException.toString());
            }
        }
    }

    private void writeExceptionValue(TypeDescription typeDescription, Exception exception) {
        this.writeStringValue(exception == null ? null : exception.getMessage());
        this.writeStructValue(typeDescription, exception);
    }

    private void writeInterfaceValue(TypeDescription typeDescription, XInterface xInterface) {
        this.writeInterface(xInterface, new Type(typeDescription));
    }

    private void write32Bit(int n) {
        try {
            this.output.writeInt(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    private void writeCompressedNumber(int n) {
        if (n >= 0 && n < 255) {
            this.write8Bit(n);
        } else {
            this.write8Bit(255);
            this.write32Bit(n);
        }
    }

    private void writeBytes(byte[] byArray) {
        try {
            this.output.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }
}

