/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.ant.tasks;

import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * Search in compareList with search words given in searchList, returns correspondending entries in returnFromList
 *
 * @author <a href="mailto:felix.marx@open-xchange.com">Felix Marx</a>
 */
public class SetPropertyByListCompare extends Task {

    private String[] returnFromList;
    private String[] compareList;
    private String[] searchList;
    private String propertyName;
    private String getList;

    public SetPropertyByListCompare() {
        super();
    }

    public final void setPropertyName(final String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReturnFromList(final String returnFromList){
        if (returnFromList.length() != 0){
            this.returnFromList = returnFromList.split(",",0);
        }
    }

    public void setCompareList(final String compareList){
        if (compareList.length() != 0){
            this.compareList = compareList.split(",",0);
        }
    }

    public void setSearchList(final String searchList){
        if (searchList.length() != 0){
            this.searchList = searchList.split(",",0);
        }
    }

    public void setGetList(final String getList) {
        if (getList.length() != 0){
            this.getList = getList;
        }
    }

    @Override
    public final void execute() throws BuildException {
        if (null == returnFromList) {
            return;
        }
        if(searchList == null){
            System.out.println(propertyName + " => ");
            getProject().setInheritedProperty(propertyName , "");
            return;
        }

        if (returnFromList.length == 1){
            System.out.println(propertyName + " => " + returnFromList[0]);
            getProject().setInheritedProperty(propertyName , returnFromList[0]);
            return;
        }

        if (compareList.length == 1 && getList == null){
            System.out.println(propertyName + " => " + returnFromList[0]);
            getProject().setInheritedProperty(propertyName , returnFromList[0]);
            return;
        }

        HashMap<String,String> hashMap = new HashMap<String,String>();
        if (compareList.length == 1){
            for (int i = 0 ; i< returnFromList.length ; i++){
                if (hashMap.containsKey(compareList[0])){
                    hashMap.put(compareList[0], hashMap.get(compareList[0]) +","+ returnFromList[i]);
                } else {
                    hashMap.put(compareList[0], returnFromList[i]);
                }
            }
        } else if (compareList.length != returnFromList.length ){
            throw new BuildException("compareList has different length than searchList.");
        } else {
            for (int i = 0 ; i< compareList.length ; i++){
                if (hashMap.containsKey(compareList[i])){
                    hashMap.put(compareList[i], hashMap.get(compareList[i]) +","+ returnFromList[i]);
                } else {
                    hashMap.put(compareList[i], returnFromList[i]);
                }
            }
        }

        StringBuilder sb = new StringBuilder();

        for (String s:searchList){
            if (hashMap.containsKey(s)){
                if (sb.length() != 0){
                    sb.append(",");
                }
                sb.append(hashMap.get(s));
            }
        }
        System.out.println(propertyName + " => " + sb.toString());
        getProject().setInheritedProperty(propertyName , sb.toString());


    }



}
