/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.IsoBufferWrapper;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.Descriptor;
import java.io.IOException;

@Descriptor(tags={0})
public abstract class BaseDescriptor {
    int tag;
    int sizeOfInstance;
    byte[] data;
    int sizeBytes;

    public int getTag() {
        return this.tag;
    }

    public int getSize() {
        return this.sizeOfInstance + 1 + this.sizeBytes;
    }

    public int getSizeOfInstance() {
        return this.sizeOfInstance;
    }

    public int getSizeBytes() {
        return this.sizeBytes;
    }

    public void parse(int tag, IsoBufferWrapper in, int maxLength) throws IOException {
        this.tag = tag;
        int i = 0;
        int tmp = in.readUInt8();
        ++i;
        this.sizeOfInstance = tmp & 0x7F;
        while (tmp >>> 7 == 1) {
            tmp = in.readUInt8();
            ++i;
            this.sizeOfInstance = this.sizeOfInstance << 7 | tmp & 0x7F;
        }
        this.sizeBytes = i;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BaseDescriptor");
        sb.append("{tag=").append(this.tag);
        sb.append(", sizeOfInstance=").append(this.sizeOfInstance);
        sb.append('}');
        return sb.toString();
    }
}

