/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import java.util.List;
import javapns.json.JSONException;
import javapns.json.JSONNull;
import javapns.json.JSONObject;
import javapns.notification.Payload;
import javapns.notification.exceptions.PayloadAlertAlreadyExistsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushNotificationPayload
extends Payload {
    private static final int MAXIMUM_PAYLOAD_LENGTH = 256;
    private JSONObject apsDictionary;

    public static PushNotificationPayload alert(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Alert cannot be null");
        }
        PushNotificationPayload payload = PushNotificationPayload.complex();
        try {
            payload.addAlert(message);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return payload;
    }

    public static PushNotificationPayload badge(int badge) {
        PushNotificationPayload payload = PushNotificationPayload.complex();
        try {
            payload.addBadge(badge);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return payload;
    }

    public static PushNotificationPayload sound(String sound) {
        if (sound == null) {
            throw new IllegalArgumentException("Sound name cannot be null");
        }
        PushNotificationPayload payload = PushNotificationPayload.complex();
        try {
            payload.addSound(sound);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return payload;
    }

    public static PushNotificationPayload combined(String message, int badge, String sound) {
        if (message == null && badge < 0 && sound == null) {
            throw new IllegalArgumentException("Must provide at least one non-null argument");
        }
        PushNotificationPayload payload = PushNotificationPayload.complex();
        try {
            if (message != null) {
                payload.addAlert(message);
            }
            if (badge >= 0) {
                payload.addBadge(badge);
            }
            if (sound != null) {
                payload.addSound(sound);
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        return payload;
    }

    public static PushNotificationPayload test() {
        PushNotificationPayload payload = PushNotificationPayload.complex();
        payload.setPreSendConfiguration(1);
        return payload;
    }

    public static PushNotificationPayload complex() {
        PushNotificationPayload payload = new PushNotificationPayload();
        return payload;
    }

    public static PushNotificationPayload fromJSON(String rawJSON) throws JSONException {
        PushNotificationPayload payload = new PushNotificationPayload(rawJSON);
        return payload;
    }

    public PushNotificationPayload() {
        this.apsDictionary = new JSONObject();
        try {
            JSONObject payload = this.getPayload();
            if (!payload.has("aps")) {
                payload.put("aps", this.apsDictionary);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public PushNotificationPayload(String rawJSON) throws JSONException {
        super(rawJSON);
        try {
            JSONObject payload = this.getPayload();
            this.apsDictionary = payload.getJSONObject("aps");
            if (this.apsDictionary == null) {
                this.apsDictionary = new JSONObject();
                payload.put("aps", this.apsDictionary);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public PushNotificationPayload(String alert, int badge, String sound) throws JSONException {
        this();
        if (alert != null) {
            this.addAlert(alert);
        }
        this.addBadge(badge);
        if (sound != null) {
            this.addSound(sound);
        }
    }

    public void addBadge(int badge) throws JSONException {
        logger.debug((Object)("Adding badge [" + badge + "]"));
        this.put("badge", badge, this.apsDictionary, true);
    }

    public void addSound(String sound) throws JSONException {
        logger.debug((Object)("Adding sound [" + sound + "]"));
        this.put("sound", sound, this.apsDictionary, true);
    }

    public void addAlert(String alertMessage) throws JSONException {
        String previousAlert = this.getCompatibleProperty("alert", String.class, "A custom alert (\"%s\") was already added to this payload");
        logger.debug((Object)("Adding alert [" + alertMessage + "]" + (previousAlert != null ? " replacing previous alert [" + previousAlert + "]" : "")));
        this.put("alert", alertMessage, this.apsDictionary, false);
    }

    private JSONObject getOrAddCustomAlert() throws JSONException {
        JSONObject alert = this.getCompatibleProperty("alert", JSONObject.class, "A simple alert (\"%s\") was already added to this payload");
        if (alert == null) {
            alert = new JSONObject();
            this.put("alert", alert, this.apsDictionary, false);
        }
        return alert;
    }

    private <T> T getCompatibleProperty(String propertyName, Class<T> expectedClass, String exceptionMessage) throws JSONException {
        return this.getCompatibleProperty(propertyName, expectedClass, exceptionMessage, this.apsDictionary);
    }

    private <T> T getCompatibleProperty(String propertyName, Class<T> expectedClass, String exceptionMessage, JSONObject dictionary) throws JSONException {
        Object propertyValue = null;
        try {
            propertyValue = dictionary.get(propertyName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue.getClass().equals(expectedClass)) {
            return (T)propertyValue;
        }
        try {
            exceptionMessage = String.format(exceptionMessage, propertyValue);
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new PayloadAlertAlreadyExistsException(exceptionMessage);
    }

    public void addCustomAlertBody(String body) throws JSONException {
        this.put("body", body, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertActionLocKey(String actionLocKey) throws JSONException {
        Object value = actionLocKey != null ? actionLocKey : new JSONNull();
        this.put("action-loc-key", value, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertLocKey(String locKey) throws JSONException {
        this.put("loc-key", locKey, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertLocArgs(List args) throws JSONException {
        this.put("loc-args", args, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertLaunchImage(String launchImage) throws JSONException {
        this.put("launch-image", launchImage, this.getOrAddCustomAlert(), false);
    }

    @Override
    public int getMaximumPayloadSize() {
        return 256;
    }

    @Override
    void verifyPayloadIsNotEmpty() {
        if (this.getPreSendConfiguration() != 0) {
            return;
        }
        if (this.toString().equals("{\"aps\":{}}")) {
            throw new IllegalArgumentException("Payload cannot be empty");
        }
    }
}

