# Contributing To The Bootstrap Accessibility Plugin

We are always looking for ways to make this plugin better. A bug-free code will lead to better user experience and, ultimately, healthier web!
Feel free to raise a pull request to us. Our team would review your proposed modifications and, if appropriate, merge your changes into our code. Ideas and other comments are also welcome.
Please make sure you have installed the plugin as per instructions below before raising bugs though.

## Getting Started
1. [Fork](https://help.github.com/articles/fork-a-repo) this [repository](https://github.com/paypal/bootstrap-accessibility-plugin/fork) on GitHub
2. Clone your fork 
  ```sh
  git clone git@github.com:yourname/bootstrap-accessibility-plugin.git

  ```
3. Add an upstream remote
```sh

   git remote add upstream git://github.com/paypal/bootstrap-accessibility-plugin.git
```
4. Get the latest changes from upstream
  ```sh
   git pull upstream
  ```
5. Initialize git submodules:
  ```sh
  cd bootstrap-accessibility-plugin
  git submodule init
  git submodule update       
  ```
4. Install Grunt-cli 
  ```sh
   sudo npm install grunt-cli -g
   npm install  
  ```

## Making Changes 
1. Make sure that your changes adhere to the current coding conventions used throughout the project, indentation, accurate comments, etc.
2. Run JSLint by running Grunt from the root of your repo, to make sure there are no errors and to generate Minified plugin file.

  ```sh
     grunt  
  ```

## Submitting Changes
1. Ensure that no errors are generated by JSLint, CSSLint or any other tools that you use for debugging your code.
2. Commit your changes in logical chunks, i.e. keep your changes small per single commit.
3. Locally merge (or rebase) the upstream branch into your topic branch.
  ```sh
  
   git pull upstream
   git merge   
  ```
3. Push your topic branch up to your fork (git push origin <topic-branch-name>).
4. Open a [Pull Request](https://help.github.com/articles/using-pull-requests) with a clear title and description. Remember to mention which browsers and assistive technology you tested your changes with.

If you have any questions about contributing, please feel free to contact us by posting your questions on Github.

Copyright 2014, eBay Software Foundation under [the BSD license](LICENSE.md).
