// Utilities which are used at runtime and by the build system itself.

if (!("_" in this)) _ = function(s) { return s; }; // TODO: i18n

/**
 * Formats a string by replacing printf-style format specifiers in the string
 * with dynamic parameters. Flags, width, precision and length modifiers are
 * not supported. All type conversions are performed by the standard toString()
 * JavaScript method.
 * @param {String} string The format string.
 * @param params Either an array with parameters or multiple separate
 * parameters.
 * @type String
 * @return The formatted string.
 */
function format(string, params) {
    var param_array = params;
    if (typeof(params) != "object") {
        param_array = new Array(arguments.length - 1);
        for (var i = 1; i < arguments.length; i++)
            param_array[i - 1] = arguments[i];
    }
    var index = 0;
    return String(string).replace(/%(([0-9]+)\$)?[A-Za-z]/g,
        function(match, pos, n) {
            if (pos) index = n - 1;
            return param_array[index++];
        }).replace(/%%/, "%");
}

/**
 * Creates the prototype object of a subclass.
 * @param {Function} parent The constructor function of the superclass.
 * @param {Object} prototype The prototype object of the subclass, containing
 * only new and overridden members.
 * @type Object
 * @return The prototype object with all inherited members added to it.
 */
function extend(parent, prototype) {
    for (var i in parent.prototype)
        if (!(i in prototype)) prototype[i] = parent.prototype[i];
    return prototype;
}

/**
 * Escapes a string to be included in an HTML file.
 * The characters '<', '>', '&', '"' and "'" are replaced by their HTML entity
 * references.
 * @param {String} s The string to escape.
 * @type String
 * @return The escaped string.
 */
function escapeHTML(s) {
    return s.replace(/[<>&"]/g, function(c) { return htmlEscapes[c]; });
}
var htmlEscapes = { "<": "&lt;", ">": "&gt;", "&": "&amp;", "\"": "&quot;" };
