/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * 
 */

/*
 * Experimental!
 */

var replaceRenderer = (function () {
    
    // skip menu items
    var skip = {
            
        "mail-compose-compose": true,
        "calendar-edit-compose": true,
        "contacts-edit-compose": true,
        "contacts-edit-composeDistributionList": true,
        "tasks-edit-compose": true,
        "infostore-edit-compose": true,
        
        "mail-edit-move": true,
        "mail-edit-view-source": true,
        
        "toolbar-mail-attachment": true,
        
        "tasks-edit-mark-as-done": true,
        
        "mail_new-cancel": true,
        "mail_detail-cancel": true,
        "calendar_new-cancel": true,
        "contact_new-cancel": true,
        "task_new-cancel": true,
        "infostore_new-cancel": true
    };
    
    // keep small
    var keepSmall = {
            
        "calendar-teamview-add": true,
        "calendar-teamview-remove": true,
        "calendar-teamview-choose-team": true,
        "calendar-teamview-create-team": true,
        
        "mail_detail-flag-0": true,
        "mail_detail-flag-1": true,
        "mail_detail-flag-2": true,
        "mail_detail-flag-3": true,
        "mail_detail-flag-4": true,
        "mail_detail-flag-5": true,
        "mail_detail-flag-6": true,
        "mail_detail-flag-7": true,
        "mail_detail-flag-8": true,
        "mail_detail-flag-9": true,
        "mail_detail-flag-10": true
        
    };

    var makeSplit = {
        "portalCreateSection": 0,
        "mailCreateSection": 0,
        "calendarCreateSection": 1,
        "contactsCreateSection": 2,
        "tasksCreateSection": 4,
        "infostoreCreateSection": 5
    };
    
    // make big (give higher priority)
    var makeBig = {
        
        "mail-create-mail": true,
        "calendar-create-calendar": true,
        "contacts-create-contact": true,
        "tasks-create-task": true,
        "infostore-create-file": true,
        
        "mail-edit-copy": true,
        "mail-edit-print": true,
        "mail-edit-save": true,
        "mail-edit-mark-as": true,
        "mail-edit-spam": true,
        "mail-edit-ham": true,
        
        "mail_detail-edit-print": true,
        "mail_detail-edit-mark-as": true,
        "mail_detail-edit-save": true,
        "mail_detail-edit-view-source": true,
        "mail_detail-edit-spam": true,
        "mail_detail-edit-ham": true,
        
        "contacts-edit-print": true,
        "contacts-edit-copy": true,
        "contacts-edit-move": true,
        "contacts-edit-duplicate": true,
        "contacts-edit-sendmail": true,
        "contacts-edit-vcard": true,
        
        "tasks-edit-print": true,
        "tasks-edit-move": true,
        "tasks-edit-use-as-template": true,
        
        "infostore-edit-print": true,
        "infostore-edit-lock": true,
        "infostore-edit-unlock": true,
        "infostore-edit-move": true
    };

    // parts
    var parts = {
            
        "mail-create-mail": "icon",
        "calendar-create-calendar": "icon",
        "contacts-create-contact": "icon",
        "tasks-create-task": "icon",
        "infostore-create-file": "icon",
            
        "mail-edit-copy": "icon",
        "mail-edit-print": "icon",
        "mail-edit-save": "icon",
        "mail-edit-mark-as": "icon",
        
        "mail_detail-edit-print": "icon",
        //"mail_detail-edit-mark-as": "icon",
        "mail_detail-edit-save": "icon",
        "mail_detail-edit-view-source": "icon",
        
        "calendar-edit-print": "icon",
        
        "contacts-edit-print": "icon",
        "contacts-edit-copy": "icon",
        "contacts-edit-move": "icon",
        
        "tasks-edit-print": "icon",
        //"tasks-edit-move": "icon",
        "tasks-edit-use-as-template": "icon",
        
        "infostore-edit-print": "icon",
        "infostore-edit-lock": "icon",
        "infostore-edit-unlock": "icon"
    };
    
    return function (window, replacePrototype) {
        
        var ox = window.ox;
        var resizeSplit = window.resizeSplit;
        var $ = window.jQuery;
        
        // reset all existing tab controls
        var id, views = ox.widgets.toolBar.views;
        for (id in views) {
            views[id].requiresValidation = true;
        }
        
        // adjust scaffold
        $("#notheader").children().css("top", "30px");
        $("#notheader").prepend(
             $("#toolbar_container").css({
                 position: "absolute",
                 top: "0px",
                 right: "0px",
                 left: "0px",
                 margin: "0px 0px 0px 0px",
                 zIndex: "0"
             })
        );
        
        // override resize
        ox.ToolBarController.initialResize = function () {
            var height = ox.api.window.isNested ? "30px" : "0px";
            $("#toolbar_container, #window_toolbar_container").height(height);
            resizeSplit("all_of_menu", height);
        };
        
        ox.ToolBarController.resize = function (e) {
            var height = ox.api.window.isNested ? "30px" : "0px";
            $("#toolbar_container, #window_toolbar_container").height(height);
            resizeSplit("all_of_menu", height);
        };
        
        // override classes & layout managers
        ox.gui.TabMenu.prototype.setPosition = $.noop;
        ox.gui.TabMenu.prototype.showChild = $.noop;
        ox.gui.TabMenu.prototype.hideCurrentChild = $.noop;
        ox.gui.TabMenu.prototype.toggle = $.noop;
        ox.gui.TabMenu.prototype.expand = $.noop;
        ox.gui.TabMenu.prototype.collapse = $.noop;
        
        /*
         * TabMenu Layout
         */
        var altLayout = function () {
            
            var con = this.container;
            var kindergarten = $(con.dom.node);
            
            if (con.getClass() === "ox.gui.TabMenu") {
                kindergarten.addClass("bg-toolbar-compact toolbar-compact-tab");
            } else if (con.getClass() === "ox.gui.PanelMenu") {
                kindergarten.addClass("toolbar-compact-panel").css({
                    height: "" // remove fixed height
                });
            }
            
            // park nodes
            this.park();
            this.park(con.submenu || null);
            
            // first run
            if (this.altRendered === undefined) {
                // clear
                kindergarten.empty();
                // create table
                this.table = $("<table/>", {
                    cellPadding: 0, cellSpacing: 0, border: 0
                }).append(
                    $("<tbody/>").append(
                        this.row = $("<tr/>")
                    )
                ).appendTo(kindergarten);
            }
            
            // clear row
            this.row.empty();
            
            if (con.getClass() === "ox.gui.PanelMenuSection") {
                
                // make split?
                if (makeSplit[con.id] !== undefined) {
                    // get child
                    var pos = makeSplit[con.id],
                        children = con.getChildren().slice(), // simple clone
                        widget = children[pos],
                        clone;
                    if (widget && widget.options.behavior !== "split") {
                        // clone widget
                        clone = ox.util.create(ox.gui.MenuItem, $.extend(widget.options, {
                            id: widget.id + "-clone",
                            title: _("New"),
                            tooltip: widget.options.title
                        }));
                        // set to "split"
                        clone.options.behavior = "split";
                        // move children
                        $.each(children, function (i, child) {
                            child.forceSmallIcon = true;
                            child.text = child.options.abbr;
                            clone.add(child);
                        });
                        // move one child to top
                        clone.moveChild(widget, 0);
                        // add
                        clone.addTo(con);
                    }
                }
                // always active (menus open on mouse over)
                con.statusActive = true;
                // loop over big items
                var i = 0, items = con.getChildren(), $i = items.length, item, td, submenu;
                // flatten big icons?
                var flatBig = con.parent.position === 1 || ox.api.window.isNested;
                var flatAll = false;
                var flats = {};
                for (; i < $i; i++) {
                    // get item
                    item = items[i];
                    flatAll = $i === 1 || makeBig[item.id] !== undefined;
                    // skip?
                    if (skip[item.id] === undefined) {
                        // search field?
                        if (item.getClass() === "ox.gui.SearchField") {
                            // create table cell
                            td = $("<td/>").css({
                                padding: "0px 5px 0px 5px"
                            }).append(item.dom.node);
                            item.options.width = 150;
                            item.paint();
                            this.row.append(td);
                            flats[item.id] = true;
                        } 
                        else if ((flatAll || (flatBig && item.bigIcon)) && keepSmall[item.id] === undefined) {
                            // create table cell
                            td = $("<td/>").append(item.dom.node);
                            // make small now
                            item.forceSmallIcon = true;
                            item.options.parts = parts[item.id] || "both";
                            item.menuStripAlign = "bottom";
                            item.paint();
                            // add TD
                            this.row.append(td);
                            flats[item.id] = true;
                        }
                    }
                }
                
                // adjust get children
                var getChildren = function () {
                    return $.grep(con.getChildren(), function (child) {
                        return (flats[child.id] === undefined && skip[child.id] === undefined) || keepSmall[child.id] === true;
                    });
                };
                
                // loop over items
                var i = 0, items = getChildren(), $i = items.length, item, td, submenu;
                for (; i < $i; i++) {
                    // get item
                    item = items[i];
                    item.options.parts = parts[item.id] || "both";
                    item.forceSmallIcon = true;
                    item.paint();
                }
                
                if ($i > 0) {
                    // add sub menu
                    submenu = con.submenu;
                    if (submenu === undefined) {
                        submenu = con.submenu = ox.util.create(ox.gui.MenuItem, {
                            id: con.id + "-submenu",
                            title: con.text,
                            parts: parts[con.id] || "both"
                        });
                        // align
                        submenu.menuStripAlign = "bottom";
                        // set children
                        submenu.parent = con;
                        submenu.getChildren = function () {
                            return getChildren();
                        };
                        // set hover parent
                        for (i = 0; i < $i; i++) {
                            items[i].hoverParent = submenu;
                        }
                        // validate sub menu
                        submenu.validate();
                        // initialize menu strip
                        submenu.menuStrip = ox.util.create(ox.gui.MenuStrip);
                        submenu.menuStrip.parent = submenu;
                        // adjust "hideHovers"
                        con.hideHovers = function () {
                            ox.gui.Container.prototype.hideHovers.call(this);
                            submenu.hideHovers();
                        };
                    } else {
                        submenu.validate(true);
                    }
                    // create table cell
                    td = $("<td/>");
                    // add sub menu
                    td.append(submenu.dom.node);
                    // add TD
                    this.row.append(td);
                }
                
            } else {
                    
                // loop over items
                var i = 0, items = con.getChildren(), $i = items.length, item, td, submenu;
                for (; i < $i; i++) {
                    // get item
                    item = items[i];
                    // create table cell
                    td = $("<td/>");
                    // individual adjustments
                    switch (item.getClass()) {
                    case "ox.gui.PanelMenu":
                        // skip?
                        if (skip[item.id] === undefined) {
                            // make visible
                            item.setVisible(true);
                            // add
                            td.append(item.dom.node);
                        }
                        break;
                    case "ox.gui.MenuItem":
                        // set parts
                        item.options.parts = parts[item.id] || "both";
                        // make icons small
                        item.bigIcon = false;
                        // add
                        td.append(item.dom.node);
                        break;
                    default:
                        // add
                        td.append(item.dom.node);
                    }
                    // add TD
                    this.row.append(td);
                    // first run?
                    if (!this.altRendered) {
                        // force repaint
                        item.paint();
                    }
                }
            }
            
            this.altRendered = true;
        };
        
        if (replacePrototype) {
            // replace prototypes
            ox.gui.TabMenuLayout.prototype.doLayout = altLayout;
            ox.gui.PanelMenuLayout.prototype.doLayout = altLayout;
            ox.gui.PanelMenuSectionLayout.prototype.doLayout = altLayout;
        } else {
            // due to a Firefox 3.5 bug...
            // loop over all relevant widgets
            var tmp = ox.desktop.registry.widget.list, id, obj, type;
            for (id in tmp) {
                obj = tmp[id];
                type = obj.getClass();
                if (/^ox\.gui\.(TabMenu|PanelMenu|PanelMenuSection)/.test(type)) {
                    // replace object method, not via prototype
                    obj.layoutManager.doLayout = altLayout;
                }
            }
        }
        
        /*
         * Resize
         */
        ox.ToolBarController.initialResize();
        
        // change sidebar style
        if (ox.widgets && ox.widgets.sidepanel) {
            ox.widgets.sidepanel.title.addCSSClass("headercontenttable border-color-design")
                .css({ padding: "0px", color: "#333" });
        }
    };
    
}());

// replace in core window
replaceRenderer(window, true);

// replace in sub windows
register("OX_Window_Ready", function (data) {
    var guid = data.handle;
    var w = ox.api.window.get(guid);
    if (w && w.window) {
        replaceRenderer(w.window, false);
        var views = w.window.ox.widgets.toolBar.views;
        for (var id in views) {
            views[id].paint();
        }
    }
});
